/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.ValueMatchingStrategy;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;

public class MappingBuilder {
    private RequestPatternBuilder requestPatternBuilder;
    private ResponseDefinitionBuilder responseDefBuilder;
    private Integer priority;
    private String scenarioName;
    private String requiredScenarioState;
    private String newScenarioState;

    public MappingBuilder(RequestMethod method, UrlMatchingStrategy urlMatchingStrategy) {
        this.requestPatternBuilder = new RequestPatternBuilder(method, urlMatchingStrategy);
    }

    public MappingBuilder willReturn(ResponseDefinitionBuilder responseDefBuilder) {
        this.responseDefBuilder = responseDefBuilder;
        return this;
    }

    public MappingBuilder atPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public MappingBuilder withHeader(String key, ValueMatchingStrategy headerMatchingStrategy) {
        this.requestPatternBuilder.withHeader(key, headerMatchingStrategy);
        return this;
    }

    public MappingBuilder withQueryParam(String key, ValueMatchingStrategy queryParamMatchingStrategy) {
        this.requestPatternBuilder.withQueryParam(key, queryParamMatchingStrategy);
        return this;
    }

    public MappingBuilder withRequestBody(ValueMatchingStrategy bodyMatchingStrategy) {
        this.requestPatternBuilder.withRequestBody(bodyMatchingStrategy);
        return this;
    }

    public MappingBuilder inScenario(String scenarioName) {
        this.scenarioName = scenarioName;
        return this;
    }

    public MappingBuilder whenScenarioStateIs(String stateName) {
        this.requiredScenarioState = stateName;
        return this;
    }

    public MappingBuilder willSetStateTo(String stateName) {
        this.newScenarioState = stateName;
        return this;
    }

    public StubMapping build() {
        if (this.scenarioName == null && (this.requiredScenarioState != null || this.newScenarioState != null)) {
            throw new IllegalStateException("Scenario name must be specified to require or set a new scenario state");
        }
        RequestPattern requestPattern = this.requestPatternBuilder.build();
        ResponseDefinition response = this.responseDefBuilder.build();
        StubMapping mapping = new StubMapping(requestPattern, response);
        mapping.setPriority(this.priority);
        mapping.setScenarioName(this.scenarioName);
        mapping.setRequiredScenarioState(this.requiredScenarioState);
        mapping.setNewScenarioState(this.newScenarioState);
        return mapping;
    }
}

