/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.KeyStoreSettings;
import com.google.common.io.Resources;

public class HttpsSettings {
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean needClientAuth;

    public HttpsSettings(int port, String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword, boolean needClientAuth) {
        this.port = port;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.needClientAuth = needClientAuth;
    }

    public int port() {
        return this.port;
    }

    public String keyStorePath() {
        return this.keyStorePath;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public boolean enabled() {
        return this.port > -1;
    }

    public String trustStorePath() {
        return this.trustStorePath;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean needClientAuth() {
        return this.needClientAuth;
    }

    public boolean hasTrustStore() {
        return this.trustStorePath != null;
    }

    public KeyStoreSettings trustStore() {
        return this.trustStorePath != null ? new KeyStoreSettings(this.trustStorePath, this.trustStorePassword) : KeyStoreSettings.NO_STORE;
    }

    public String toString() {
        return "HttpsSettings{port=" + this.port + ", keyStorePath='" + this.keyStorePath + '\'' + ", trustStorePath='" + this.trustStorePath + '\'' + ", needClientAuth=" + this.needClientAuth + '}';
    }

    public static class Builder {
        private int port;
        private String keyStorePath = Resources.getResource((String)"keystore").toString();
        private String keyStorePassword = "password";
        private String trustStorePath = null;
        private String trustStorePassword = "password";
        private boolean needClientAuth = false;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder needClientAuth(boolean needClientAuth) {
            this.needClientAuth = needClientAuth;
            return this;
        }

        public HttpsSettings build() {
            return new HttpsSettings(this.port, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword, this.needClientAuth);
        }
    }
}

