/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.matching.ValuePattern;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;

public class MultiValue {
    protected final String key;
    protected final List<String> values;

    public MultiValue(String key, List<String> values) {
        this.key = key;
        this.values = values;
    }

    public boolean isPresent() {
        return this.values.size() > 0;
    }

    public String key() {
        return this.key;
    }

    public String firstValue() {
        this.checkPresent();
        return this.values.get(0);
    }

    public List<String> values() {
        this.checkPresent();
        return this.values;
    }

    private void checkPresent() {
        Preconditions.checkState((boolean)this.isPresent(), (Object)("No value for " + this.key));
    }

    public boolean isSingleValued() {
        return this.values.size() == 1;
    }

    public boolean containsValue(String expectedValue) {
        return this.values.contains(expectedValue);
    }

    public boolean hasValueMatching(ValuePattern valuePattern) {
        return valuePattern.nullSafeIsAbsent() && !this.isPresent() || this.anyValueMatches(valuePattern);
    }

    private boolean anyValueMatches(final ValuePattern valuePattern) {
        return Iterables.any(this.values, (Predicate)new Predicate<String>(){

            public boolean apply(String headerValue) {
                return valuePattern.isMatchFor(headerValue);
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String value : this.values) {
            sb.append(this.key).append(": ").append(value).append("\n");
        }
        return sb.toString();
    }
}

