/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

public class ProxyResponseRenderer
implements ResponseRenderer {
    private static final int MINUTES = 60000;
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String CONTENT_LENGTH = "content-length";
    private final HttpClient client;

    public ProxyResponseRenderer(ProxySettings proxySettings) {
        this.client = proxySettings != null ? HttpClientFactory.createClient(1000, 300000, proxySettings) : HttpClientFactory.createClient(1000, 300000);
    }

    public ProxyResponseRenderer() {
        this(ProxySettings.NO_PROXY);
    }

    @Override
    public Response render(ResponseDefinition responseDefinition) {
        HttpUriRequest httpRequest = ProxyResponseRenderer.getHttpRequestFor(responseDefinition);
        httpRequest.removeHeaders("Host");
        ProxyResponseRenderer.addRequestHeaders((HttpRequest)httpRequest, responseDefinition);
        try {
            ProxyResponseRenderer.addBodyIfPostOrPut((HttpRequest)httpRequest, responseDefinition);
            HttpResponse httpResponse = this.client.execute(httpRequest);
            return Response.response().status(httpResponse.getStatusLine().getStatusCode()).headers(this.headersFrom(httpResponse)).body(HttpClientUtils.getEntityAsByteArrayAndCloseStream(httpResponse)).fromProxy(true).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpHeaders headersFrom(HttpResponse httpResponse) {
        return new HttpHeaders(Iterables.transform(Arrays.asList(httpResponse.getAllHeaders()), (Function)new Function<Header, HttpHeader>(){

            public HttpHeader apply(Header header) {
                return new HttpHeader(header.getName(), header.getValue());
            }
        }));
    }

    private static HttpUriRequest getHttpRequestFor(ResponseDefinition response) {
        RequestMethod method = response.getOriginalRequest().getMethod();
        String url = response.getProxyUrl();
        LocalNotifier.notifier().info("Proxying: " + (Object)((Object)method) + " " + url);
        switch (method) {
            case GET: {
                return new HttpGet(url);
            }
            case POST: {
                return new HttpPost(url);
            }
            case PUT: {
                return new HttpPut(url);
            }
            case DELETE: {
                return new HttpDelete(url);
            }
            case HEAD: {
                return new HttpHead(url);
            }
            case OPTIONS: {
                return new HttpOptions(url);
            }
            case TRACE: {
                return new HttpTrace(url);
            }
        }
        throw new RuntimeException("Cannot create HttpMethod for " + (Object)((Object)method));
    }

    private static void addRequestHeaders(HttpRequest httpRequest, ResponseDefinition response) {
        Request originalRequest = response.getOriginalRequest();
        for (String key : originalRequest.getAllHeaderKeys()) {
            if (!ProxyResponseRenderer.headerShouldBeTransferred(key)) continue;
            String value = originalRequest.getHeader(key);
            httpRequest.addHeader(key, value);
        }
    }

    private static boolean headerShouldBeTransferred(String key) {
        return !ImmutableList.of((Object)CONTENT_LENGTH, (Object)TRANSFER_ENCODING).contains((Object)key.toLowerCase());
    }

    private static void addBodyIfPostOrPut(HttpRequest httpRequest, ResponseDefinition response) throws UnsupportedEncodingException {
        Request originalRequest = response.getOriginalRequest();
        if (originalRequest.getMethod().isOneOf(RequestMethod.PUT, RequestMethod.POST)) {
            HttpEntityEnclosingRequest requestWithEntity = (HttpEntityEnclosingRequest)httpRequest;
            requestWithEntity.setEntity(ProxyResponseRenderer.buildEntityFrom(originalRequest));
        }
    }

    private static HttpEntity buildEntityFrom(Request originalRequest) {
        ContentTypeHeader contentTypeHeader = originalRequest.contentTypeHeader().or("text/plain");
        ContentType contentType = ContentType.create((String)contentTypeHeader.mimeTypePart(), (String)((String)contentTypeHeader.encodingPart().or((Object)"utf-8")));
        if (originalRequest.containsHeader(TRANSFER_ENCODING) && originalRequest.header(TRANSFER_ENCODING).firstValue().equals("chunked")) {
            return new InputStreamEntity((InputStream)new ByteArrayInputStream(originalRequest.getBodyAsString().getBytes()), -1L, contentType);
        }
        return new StringEntity(originalRequest.getBodyAsString(), contentType);
    }
}

