/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.RequestDelayControl;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadSafeRequestDelayControl
implements RequestDelayControl {
    private AtomicInteger delayMilliseconds = new AtomicInteger(0);
    private ConcurrentHashMap<Thread, Object> threadsBeingDelayed = new ConcurrentHashMap();

    @Override
    public void setDelay(int milliseconds) {
        LocalNotifier.notifier().info("Setting request delay to " + milliseconds + "ms");
        this.delayMilliseconds.set(milliseconds);
    }

    @Override
    public void clearDelay() {
        LocalNotifier.notifier().info("Clearing request delay");
        this.delayMilliseconds.set(0);
        this.cancelAllDelays();
    }

    @Override
    public void delayIfRequired() throws InterruptedException {
        int millis = this.delayMilliseconds.get();
        if (millis != 0) {
            this.threadsBeingDelayed.put(Thread.currentThread(), new Object());
            Thread.sleep(millis);
        }
    }

    public void cancelAllDelays() {
        for (Thread thread : this.threadsBeingDelayed.keySet()) {
            thread.interrupt();
        }
    }
}

