/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.mapping.ValuePattern;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public class HttpHeader {
    private final String key;
    private final List<String> values;

    public HttpHeader(String key, String ... values) {
        this.key = key;
        this.values = Lists.newArrayList((Object[])values);
    }

    public HttpHeader(String key, Collection<String> values) {
        this.key = key;
        this.values = Lists.newArrayList(values);
    }

    public static HttpHeader httpHeader(String key, String ... values) {
        return new HttpHeader(key, values);
    }

    public static HttpHeader absent(String key) {
        return new HttpHeader(key, new String[0]);
    }

    public static HttpHeader copyOf(HttpHeader header) {
        return new HttpHeader(header.key(), header.values());
    }

    public boolean isPresent() {
        return this.values.size() > 0;
    }

    public String key() {
        return this.key;
    }

    public String firstValue() {
        this.checkPresent();
        return this.values.get(0);
    }

    public List<String> values() {
        this.checkPresent();
        return this.values;
    }

    private void checkPresent() {
        Preconditions.checkState((boolean)this.isPresent(), (Object)("No value for header " + this.key));
    }

    public boolean isSingleValued() {
        return this.values.size() == 1;
    }

    public boolean containsValue(String expectedValue) {
        return this.values.contains(expectedValue);
    }

    public boolean hasValueMatching(final ValuePattern valuePattern) {
        return valuePattern.nullSafeIsAbsent() && !this.isPresent() || Iterables.any(this.values, (Predicate)new Predicate<String>(){

            public boolean apply(String headerValue) {
                return valuePattern.isMatchFor(headerValue);
            }
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String value : this.values) {
            sb.append(this.key).append(": ").append(value).append("\n");
        }
        return sb.toString();
    }
}

