/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ValuePattern {
    private String equalTo;
    private String contains;
    private String matches;
    private String doesNotMatch;

    public static ValuePattern equalTo(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setEqualTo(value);
        return valuePattern;
    }

    public static ValuePattern containing(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setContains(value);
        return valuePattern;
    }

    public static ValuePattern matches(String value) {
        ValuePattern valuePattern = new ValuePattern();
        valuePattern.setMatches(value);
        return valuePattern;
    }

    public boolean isMatchFor(String value) {
        this.checkOneMatchTypeSpecified();
        if (this.equalTo != null) {
            return value.equals(this.equalTo);
        }
        if (this.contains != null) {
            return value.contains(this.contains);
        }
        if (this.matches != null) {
            return this.isMatch(this.matches, value);
        }
        if (this.doesNotMatch != null) {
            return !this.isMatch(this.doesNotMatch, value);
        }
        return false;
    }

    public static Predicate<ValuePattern> matching(final String value) {
        return new Predicate<ValuePattern>(){

            public boolean apply(ValuePattern input) {
                return input.isMatchFor(value);
            }
        };
    }

    private boolean isMatch(String regex, String value) {
        Pattern pattern = Pattern.compile(regex, 32);
        return pattern.matcher(value).matches();
    }

    private void checkNoMoreThanOneMatchTypeSpecified() {
        if (this.countAllAttributes() > 1) {
            throw new IllegalStateException("Only one type of match may be specified");
        }
    }

    private void checkOneMatchTypeSpecified() {
        if (this.countAllAttributes() == 0) {
            throw new IllegalStateException("One match type must be specified");
        }
    }

    private int countAllAttributes() {
        return this.count(this.equalTo, this.contains, this.matches, this.doesNotMatch);
    }

    private int count(Object ... objects) {
        int counter = 0;
        for (Object obj : objects) {
            if (obj == null) continue;
            ++counter;
        }
        return counter;
    }

    public void setEqualTo(String equalTo) {
        this.equalTo = equalTo;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setContains(String contains) {
        this.contains = contains;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setMatches(String matches) {
        this.matches = matches;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public void setDoesNotMatch(String doesNotMatch) {
        this.doesNotMatch = doesNotMatch;
        this.checkNoMoreThanOneMatchTypeSpecified();
    }

    public String getEqualTo() {
        return this.equalTo;
    }

    public String getContains() {
        return this.contains;
    }

    public String getMatches() {
        return this.matches;
    }

    public String getDoesNotMatch() {
        return this.doesNotMatch;
    }

    public String toString() {
        if (this.equalTo != null) {
            return "equal " + this.equalTo;
        }
        if (this.contains != null) {
            return "contains " + this.contains;
        }
        if (this.matches != null) {
            return "matches " + this.matches;
        }
        return "not match " + this.doesNotMatch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contains == null ? 0 : this.contains.hashCode());
        result = 31 * result + (this.doesNotMatch == null ? 0 : this.doesNotMatch.hashCode());
        result = 31 * result + (this.equalTo == null ? 0 : this.equalTo.hashCode());
        result = 31 * result + (this.matches == null ? 0 : this.matches.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValuePattern other = (ValuePattern)obj;
        if (this.contains == null ? other.contains != null : !this.contains.equals(other.contains)) {
            return false;
        }
        if (this.doesNotMatch == null ? other.doesNotMatch != null : !this.doesNotMatch.equals(other.doesNotMatch)) {
            return false;
        }
        if (this.equalTo == null ? other.equalTo != null : !this.equalTo.equals(other.equalTo)) {
            return false;
        }
        return !(this.matches == null ? other.matches != null : !this.matches.equals(other.matches));
    }
}

