/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.mapping.RequestResponseMapping;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;

public class SortedConcurrentMappingSet
implements Iterable<RequestResponseMapping> {
    private AtomicLong insertionCount = new AtomicLong();
    private ConcurrentSkipListSet<RequestResponseMapping> mappingSet = new ConcurrentSkipListSet<RequestResponseMapping>(this.sortedByPriorityThenReverseInsertionOrder());

    private Comparator<RequestResponseMapping> sortedByPriorityThenReverseInsertionOrder() {
        return new Comparator<RequestResponseMapping>(){

            @Override
            public int compare(RequestResponseMapping one, RequestResponseMapping two) {
                int priorityComparison = one.comparePriorityWith(two);
                if (priorityComparison != 0) {
                    return priorityComparison;
                }
                return two.getInsertionIndex() > one.getInsertionIndex() ? 1 : -1;
            }
        };
    }

    @Override
    public Iterator<RequestResponseMapping> iterator() {
        return this.mappingSet.iterator();
    }

    public void add(RequestResponseMapping mapping) {
        mapping.setInsertionIndex(this.insertionCount.getAndIncrement());
        this.mappingSet.add(mapping);
    }

    public void clear() {
        this.mappingSet.clear();
    }

    public String toString() {
        return this.mappingSet.toString();
    }
}

