/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import java.util.concurrent.atomic.AtomicReference;

public class Scenario {
    public static final String STARTED = "Started";
    private final AtomicReference<String> state;

    public Scenario(String currentState) {
        this.state = new AtomicReference<String>(currentState);
    }

    public static Scenario inStartedState() {
        return new Scenario(STARTED);
    }

    public String getState() {
        return this.state.get();
    }

    public void setState(String newState) {
        this.state.set(newState);
    }

    public void reset() {
        this.state.set(STARTED);
    }

    public boolean stateIs(String state) {
        return this.getState().equals(state);
    }

    public String toString() {
        return "Scenario [currentState=" + this.state.get() + "]";
    }
}

