/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class CommandLineOptions {
    private static final String HELP = "help";
    private static final String RECORD_MAPPINGS = "record-mappings";
    private static final String PROXY_ALL = "proxy-all";
    private static final String PORT = "port";
    private static final String VERBOSE = "verbose";
    private static final String ENABLE_BROWSER_PROXYING = "enable-browser-proxying";
    private final OptionSet optionSet;
    private String helpText;

    public CommandLineOptions(String ... args) {
        OptionParser optionParser = new OptionParser();
        optionParser.accepts(PORT, "The port number for the server to listen on").withRequiredArg();
        optionParser.accepts(PROXY_ALL, "Will create a proxy mapping for /* to the specified URL").withRequiredArg();
        optionParser.accepts(RECORD_MAPPINGS, "Enable recording of all (non-admin) requests as mapping files");
        optionParser.accepts(VERBOSE, "Enable verbose logging to stdout");
        optionParser.accepts(ENABLE_BROWSER_PROXYING, "Allow wiremock to be set as a browser's proxy server");
        optionParser.accepts(HELP, "Print this message");
        this.optionSet = optionParser.parse(args);
        this.captureHelpTextIfRequested(optionParser);
    }

    private void captureHelpTextIfRequested(OptionParser optionParser) {
        if (this.optionSet.has(HELP)) {
            StringWriter out = new StringWriter();
            try {
                optionParser.printHelpOn((Writer)out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.helpText = out.toString();
        }
    }

    public boolean verboseLoggingEnabled() {
        return this.optionSet.has(VERBOSE);
    }

    public boolean recordMappingsEnabled() {
        return this.optionSet.has(RECORD_MAPPINGS);
    }

    public boolean specifiesPortNumber() {
        return this.optionSet.has(PORT);
    }

    public int portNumber() {
        return Integer.parseInt((String)this.optionSet.valueOf(PORT));
    }

    public boolean help() {
        return this.optionSet.has(HELP);
    }

    public String helpText() {
        return this.helpText;
    }

    public boolean specifiesProxyUrl() {
        return this.optionSet.has(PROXY_ALL);
    }

    public String proxyUrl() {
        return (String)this.optionSet.valueOf(PROXY_ALL);
    }

    public boolean browserProxyingEnabled() {
        return this.optionSet.has(ENABLE_BROWSER_PROXYING);
    }
}

