/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.mapping.JsonMappingCreator;
import com.github.tomakehurst.wiremock.mapping.Mappings;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

public class JsonFileMappingsLoader
implements MappingsLoader {
    private final FileSource mappingsFileSource;

    public JsonFileMappingsLoader(FileSource mappingsFileSource) {
        this.mappingsFileSource = mappingsFileSource;
    }

    @Override
    public void loadMappingsInto(Mappings mappings) {
        JsonMappingCreator jsonMappingCreator = new JsonMappingCreator(mappings);
        Iterable mappingFiles = Iterables.filter(this.mappingsFileSource.listFilesRecursively(), this.byFileExtension("json"));
        for (TextFile mappingFile : mappingFiles) {
            jsonMappingCreator.addMappingFrom(mappingFile.readContents());
        }
    }

    private Predicate<TextFile> byFileExtension(final String extension) {
        return new Predicate<TextFile>(){

            public boolean apply(TextFile input) {
                return input.name().endsWith("." + extension);
            }
        };
    }
}

