/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.mapping.AdminRequestHandler;
import com.github.tomakehurst.wiremock.mapping.InMemoryMappings;
import com.github.tomakehurst.wiremock.mapping.Mappings;
import com.github.tomakehurst.wiremock.mapping.MockServiceRequestHandler;
import com.github.tomakehurst.wiremock.mapping.RequestHandler;
import com.github.tomakehurst.wiremock.mapping.RequestListener;
import com.github.tomakehurst.wiremock.servlet.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.servlet.MockServiceResponseRenderer;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.verification.InMemoryRequestJournal;
import com.github.tomakehurst.wiremock.verification.RequestJournal;

public class WireMockApp {
    public static final String FILES_ROOT = "__files";
    private final Mappings mappings;
    private final InMemoryRequestJournal requestJournal;
    private final RequestHandler mockServiceRequestHandler;
    private final RequestHandler adminRequestHandler;
    private final GlobalSettingsHolder globalSettingsHolder = new GlobalSettingsHolder();
    public static final String ADMIN_CONTEXT_ROOT = "/__admin";

    public WireMockApp(FileSource fileSource, Notifier notifier, boolean enableBrowserProxying) {
        this.mappings = new InMemoryMappings();
        this.requestJournal = new InMemoryRequestJournal();
        this.mockServiceRequestHandler = new MockServiceRequestHandler(this.mappings, new MockServiceResponseRenderer(fileSource.child(FILES_ROOT), this.globalSettingsHolder), enableBrowserProxying);
        this.mockServiceRequestHandler.addRequestListener(this.requestJournal);
        this.adminRequestHandler = new AdminRequestHandler(this.mappings, this.requestJournal, this.globalSettingsHolder, new BasicResponseRenderer());
    }

    public RequestHandler getMockServiceRequestHandler() {
        return this.mockServiceRequestHandler;
    }

    public RequestHandler getAdminRequestHandler() {
        return this.adminRequestHandler;
    }

    public GlobalSettingsHolder getGlobalSettingsHolder() {
        return this.globalSettingsHolder;
    }

    public RequestJournal getRequestJournal() {
        return this.requestJournal;
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        mappingsLoader.loadMappingsInto(this.mappings);
    }

    public void addMockServiceRequestListener(RequestListener listener) {
        this.mockServiceRequestHandler.addRequestListener(listener);
    }
}

