/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.AdminClient;
import com.github.tomakehurst.wiremock.client.HttpClientUtils;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.MimeType;
import com.github.tomakehurst.wiremock.mapping.JsonMappingBinder;
import com.github.tomakehurst.wiremock.mapping.RequestPattern;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class HttpAdminClient
implements AdminClient {
    private static final String ADMIN_URL_PREFIX = "http://%s:%d%s/__admin";
    private static final String LOCAL_WIREMOCK_NEW_RESPONSE_URL = "http://%s:%d%s/__admin/mappings/new";
    private static final String LOCAL_WIREMOCK_RESET_URL = "http://%s:%d%s/__admin/reset";
    private static final String LOCAL_WIREMOCK_RESET_SCENARIOS_URL = "http://%s:%d%s/__admin/scenarios/reset";
    private static final String LOCAL_WIREMOCK_COUNT_REQUESTS_URL = "http://%s:%d%s/__admin/requests/count";
    private static final String WIREMOCK_GLOBAL_SETTINGS_URL = "http://%s:%d%s/__admin/settings";
    private final String host;
    private final int port;
    private final String urlPathPrefix;
    private final HttpClient httpClient;

    public HttpAdminClient(String host, int port, String urlPathPrefix) {
        this.host = host;
        this.port = port;
        this.urlPathPrefix = urlPathPrefix;
        this.httpClient = HttpClientFactory.createClient();
    }

    public HttpAdminClient(String host, int port) {
        this(host, port, "");
    }

    @Override
    public void addResponse(String responseSpecJson) {
        int status = this.postJsonAndReturnStatus(this.newMappingUrl(), responseSpecJson);
        if (status != 201) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    @Override
    public void resetMappings() {
        int status = this.postEmptyBodyAndReturnStatus(this.resetUrl());
        this.assertStatusOk(status);
    }

    @Override
    public void resetScenarios() {
        int status = this.postEmptyBodyAndReturnStatus(this.resetScenariosUrl());
        this.assertStatusOk(status);
    }

    private void assertStatusOk(int status) {
        if (status != 200) {
            throw new RuntimeException("Returned status code was " + status);
        }
    }

    @Override
    public int getRequestsMatching(RequestPattern requestPattern) {
        String json = JsonMappingBinder.write(requestPattern);
        String body = this.postJsonAssertOkAndReturnBody(this.requestsCountUrl(), json, 200);
        VerificationResult verificationResult = JsonMappingBinder.buildVerificationResultFrom(body);
        return verificationResult.getCount();
    }

    @Override
    public void updateGlobalSettings(GlobalSettings settings) {
        String json = JsonMappingBinder.write(settings);
        this.postJsonAssertOkAndReturnBody(this.globalSettingsUrl(), json, 200);
    }

    private int postJsonAndReturnStatus(String url, String json) {
        HttpPost post = new HttpPost(url);
        try {
            if (json != null) {
                post.setEntity((HttpEntity)new StringEntity(json, MimeType.JSON.toString(), "utf-8"));
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpClientUtils.getEntityAsStringAndCloseStream(response);
            return statusCode;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String postJsonAssertOkAndReturnBody(String url, String json, int expectedStatus) {
        HttpPost post = new HttpPost(url);
        try {
            HttpResponse response;
            if (json != null) {
                post.setEntity((HttpEntity)new StringEntity(json, MimeType.JSON.toString(), "utf-8"));
            }
            if ((response = this.httpClient.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() != expectedStatus) {
                throw new VerificationException("Expected status " + expectedStatus);
            }
            String body = HttpClientUtils.getEntityAsStringAndCloseStream(response);
            return body;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int postEmptyBodyAndReturnStatus(String url) {
        return this.postJsonAndReturnStatus(url, null);
    }

    private String newMappingUrl() {
        return String.format(LOCAL_WIREMOCK_NEW_RESPONSE_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String resetUrl() {
        return String.format(LOCAL_WIREMOCK_RESET_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String resetScenariosUrl() {
        return String.format(LOCAL_WIREMOCK_RESET_SCENARIOS_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String requestsCountUrl() {
        return String.format(LOCAL_WIREMOCK_COUNT_REQUESTS_URL, this.host, this.port, this.urlPathPrefix);
    }

    private String globalSettingsUrl() {
        return String.format(WIREMOCK_GLOBAL_SETTINGS_URL, this.host, this.port, this.urlPathPrefix);
    }
}

