/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.mapping.JsonMappingBinder;
import com.github.tomakehurst.wiremock.mapping.RequestPattern;
import com.github.tomakehurst.wiremock.mapping.ResponseDefinition;
import com.github.tomakehurst.wiremock.mapping.Scenario;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class RequestResponseMapping {
    public static final int DEFAULT_PRIORITY = 5;
    private RequestPattern request;
    private ResponseDefinition response;
    private Integer priority;
    private String scenarioName;
    private String requiredScenarioState;
    private String newScenarioState;
    private Scenario scenario;
    private long insertionIndex;
    public static final RequestResponseMapping NOT_CONFIGURED = new RequestResponseMapping(new RequestPattern(), ResponseDefinition.notConfigured());

    public RequestResponseMapping(RequestPattern requestPattern, ResponseDefinition response) {
        this.request = requestPattern;
        this.response = response;
    }

    public RequestResponseMapping() {
    }

    public RequestPattern getRequest() {
        return this.request;
    }

    public ResponseDefinition getResponse() {
        return this.response;
    }

    public void setRequest(RequestPattern request) {
        this.request = request;
    }

    public void setResponse(ResponseDefinition response) {
        this.response = response;
    }

    public String toString() {
        return JsonMappingBinder.write(this);
    }

    @JsonIgnore
    public long getInsertionIndex() {
        return this.insertionIndex;
    }

    @JsonIgnore
    public void setInsertionIndex(long insertionIndex) {
        this.insertionIndex = insertionIndex;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public void setScenarioName(String scenarioName) {
        this.scenarioName = scenarioName;
    }

    public String getRequiredScenarioState() {
        return this.requiredScenarioState;
    }

    public void setRequiredScenarioState(String requiredScenarioState) {
        this.requiredScenarioState = requiredScenarioState;
    }

    public String getNewScenarioState() {
        return this.newScenarioState;
    }

    public void setNewScenarioState(String newScenarioState) {
        this.newScenarioState = newScenarioState;
    }

    public void updateScenarioStateIfRequired() {
        if (this.isInScenario() && this.modifiesScenarioState()) {
            this.scenario.setState(this.newScenarioState);
        }
    }

    @JsonIgnore
    public Scenario getScenario() {
        return this.scenario;
    }

    @JsonIgnore
    public void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    @JsonIgnore
    public boolean isInScenario() {
        return this.scenarioName != null;
    }

    @JsonIgnore
    public boolean modifiesScenarioState() {
        return this.newScenarioState != null;
    }

    @JsonIgnore
    public boolean isIndependentOfScenarioState() {
        return !this.isInScenario() || this.requiredScenarioState == null;
    }

    @JsonIgnore
    public boolean requiresCurrentScenarioState() {
        return !this.isIndependentOfScenarioState() && this.requiredScenarioState.equals(this.scenario.getState());
    }

    public int comparePriorityWith(RequestResponseMapping otherMapping) {
        int thisPriority = this.priority != null ? this.priority : 5;
        int otherPriority = otherMapping.priority != null ? otherMapping.priority : 5;
        return thisPriority - otherPriority;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.insertionIndex ^ this.insertionIndex >>> 32);
        result = 31 * result + (this.newScenarioState == null ? 0 : this.newScenarioState.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
        result = 31 * result + (this.requiredScenarioState == null ? 0 : this.requiredScenarioState.hashCode());
        result = 31 * result + (this.response == null ? 0 : this.response.hashCode());
        result = 31 * result + (this.scenarioName == null ? 0 : this.scenarioName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestResponseMapping other = (RequestResponseMapping)obj;
        if (this.insertionIndex != other.insertionIndex) {
            return false;
        }
        if (this.newScenarioState == null ? other.newScenarioState != null : !this.newScenarioState.equals(other.newScenarioState)) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals(other.priority)) {
            return false;
        }
        if (this.request == null ? other.request != null : !this.request.equals(other.request)) {
            return false;
        }
        if (this.requiredScenarioState == null ? other.requiredScenarioState != null : !this.requiredScenarioState.equals(other.requiredScenarioState)) {
            return false;
        }
        if (this.response == null ? other.response != null : !this.response.equals(other.response)) {
            return false;
        }
        return !(this.scenarioName == null ? other.scenarioName != null : !this.scenarioName.equals(other.scenarioName));
    }
}

