/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.mapping.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.mapping.JsonMappingBinder;
import com.github.tomakehurst.wiremock.mapping.JsonMappingCreator;
import com.github.tomakehurst.wiremock.mapping.Mappings;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.github.tomakehurst.wiremock.mapping.RequestPattern;
import com.github.tomakehurst.wiremock.mapping.ResponseDefinition;
import com.github.tomakehurst.wiremock.servlet.ResponseRenderer;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.VerificationResult;

public class AdminRequestHandler
extends AbstractRequestHandler {
    private final Mappings mappings;
    private final JsonMappingCreator jsonMappingCreator;
    private final RequestJournal requestJournal;
    private final GlobalSettingsHolder globalSettingsHolder;

    public AdminRequestHandler(Mappings mappings, RequestJournal requestJournal, GlobalSettingsHolder globalSettingsHolder, ResponseRenderer responseRenderer) {
        super(responseRenderer);
        this.mappings = mappings;
        this.requestJournal = requestJournal;
        this.globalSettingsHolder = globalSettingsHolder;
        this.jsonMappingCreator = new JsonMappingCreator(mappings);
    }

    @Override
    public ResponseDefinition handleRequest(Request request) {
        if (this.isNewMappingRequest(request)) {
            this.jsonMappingCreator.addMappingFrom(request.getBodyAsString());
            return ResponseDefinition.created();
        }
        if (this.isResetRequest(request)) {
            this.mappings.reset();
            this.requestJournal.reset();
            return ResponseDefinition.ok();
        }
        if (this.isResetScenariosRequest(request)) {
            this.mappings.resetScenarios();
            return ResponseDefinition.ok();
        }
        if (this.isRequestCountRequest(request)) {
            return this.getRequestCount(request);
        }
        if (this.isGlobalSettingsUpdateRequest(request)) {
            GlobalSettings newSettings = JsonMappingBinder.read(request.getBodyAsString(), GlobalSettings.class);
            this.globalSettingsHolder.replaceWith(newSettings);
            return ResponseDefinition.ok();
        }
        return ResponseDefinition.notFound();
    }

    private boolean isGlobalSettingsUpdateRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/settings");
    }

    private ResponseDefinition getRequestCount(Request request) {
        RequestPattern requestPattern = JsonMappingBinder.buildRequestPatternFrom(request.getBodyAsString());
        int matchingRequestCount = this.requestJournal.countRequestsMatching(requestPattern);
        ResponseDefinition response = new ResponseDefinition(200, JsonMappingBinder.write(new VerificationResult(matchingRequestCount)));
        response.addHeader("Content-Type", "application/json");
        return response;
    }

    private boolean isResetRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/reset");
    }

    private boolean isResetScenariosRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/scenarios/reset");
    }

    private boolean isNewMappingRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/mappings/new");
    }

    private boolean isRequestCountRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/requests/count");
    }

    private static String withoutAdminRoot(String url) {
        return url.replace("/__admin", "");
    }
}

