/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.ethlo.time.ITU;
import com.ethlo.time.LeapSecondException;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DateTimeValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeValidator.class);
    private static final String DATETIME = "date-time";

    public DateTimeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext, ValidatorTypeCode type) {
        super(schemaPath, schemaNode, parentSchema, type, validationContext);
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        if (nodeType != JsonType.STRING) {
            return errors;
        }
        if (!DateTimeValidator.isLegalDateTime(node.textValue())) {
            errors.add(this.buildValidationMessage(at, node.textValue(), DATETIME));
        }
        return Collections.unmodifiableSet(errors);
    }

    private static boolean isLegalDateTime(String string) {
        try {
            block4: {
                try {
                    ITU.parseDateTime(string);
                }
                catch (LeapSecondException ex) {
                    if (ex.isVerifiedValidLeapYearMonth()) break block4;
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            logger.debug("Invalid {}: {}", (Object)DATETIME, (Object)ex.getMessage());
            return false;
        }
    }
}

