/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.walk.DefaultPropertyWalkListenerRunner;
import com.networknt.schema.walk.WalkListenerRunner;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.JsonNodeType;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class PropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    public static final String PROPERTY = "properties";
    private static final Logger logger = LoggerFactory.getLogger(PropertiesValidator.class);
    private final Map<String, JsonSchema> schemas = new LinkedHashMap<String, JsonSchema>();

    public PropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.PROPERTIES, validationContext);
        this.validationContext = validationContext;
        Iterator<String> it = schemaNode.fieldNames();
        while (it.hasNext()) {
            String pname = it.next();
            this.schemas.put(pname, validationContext.newSchema(schemaPath + "/" + pname, schemaNode.get(pname), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        CollectorContext collectorContext = CollectorContext.getInstance();
        DefaultPropertyWalkListenerRunner propertyWalkListenerRunner = new DefaultPropertyWalkListenerRunner(this.validationContext.getConfig().getPropertyWalkListeners());
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        ValidatorState state = (ValidatorState)collectorContext.get("com.networknt.schema.ValidatorState");
        for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
            Set<ValidationMessage> requiredErrors;
            JsonSchema propertySchema = entry.getValue();
            JsonNode propertyNode = node.get(entry.getKey());
            if (propertyNode != null) {
                collectorContext.getEvaluatedProperties().add(this.atPath(at, entry.getKey()));
                boolean isComplex = state.isComplexValidator();
                if (state.isComplexValidator()) {
                    state.setMatchedNode(true);
                }
                state.setComplexValidator(false);
                if (!state.isWalkEnabled()) {
                    errors.addAll(propertySchema.validate(propertyNode, rootNode, this.atPath(at, entry.getKey())));
                } else {
                    this.walkSchema(entry, node, rootNode, at, state.isValidationEnabled(), errors, propertyWalkListenerRunner);
                }
                state.setComplexValidator(isComplex);
                if (!state.isComplexValidator()) continue;
                state.setMatchedNode(true);
                continue;
            }
            if (!this.getParentSchema().hasRequiredValidator() || (requiredErrors = this.getParentSchema().getRequiredValidator().validate(node, rootNode, at)).isEmpty()) continue;
            if (state.isComplexValidator()) {
                state.setMatchedNode(false);
                return Collections.emptySet();
            }
            errors.addAll(requiredErrors);
        }
        return Collections.unmodifiableSet(errors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (this.applyDefaultsStrategy.shouldApplyPropertyDefaults() && node.getNodeType() == JsonNodeType.OBJECT) {
            this.applyPropertyDefaults((ObjectNode)node);
        }
        if (shouldValidateSchema) {
            validationMessages.addAll(this.validate(node, rootNode, at));
        } else {
            DefaultPropertyWalkListenerRunner propertyWalkListenerRunner = new DefaultPropertyWalkListenerRunner(this.validationContext.getConfig().getPropertyWalkListeners());
            for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
                this.walkSchema(entry, node, rootNode, at, shouldValidateSchema, validationMessages, propertyWalkListenerRunner);
            }
        }
        return validationMessages;
    }

    private void applyPropertyDefaults(ObjectNode node) {
        for (Map.Entry<String, JsonSchema> entry : this.schemas.entrySet()) {
            boolean applyDefault;
            JsonNode propertyNode = node.get(entry.getKey());
            JsonNode defaultNode = this.getDefaultNode(entry);
            if (defaultNode == null || !(applyDefault = propertyNode == null || propertyNode.isNull() && this.applyDefaultsStrategy.shouldApplyPropertyDefaultsIfNull())) continue;
            node.set(entry.getKey(), defaultNode);
        }
    }

    private JsonNode getDefaultNode(Map.Entry<String, JsonSchema> entry) {
        JsonSchema propertySchema = entry.getValue();
        return propertySchema.getSchemaNode().get("default");
    }

    private void walkSchema(Map.Entry<String, JsonSchema> entry, JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema, Set<ValidationMessage> validationMessages, WalkListenerRunner propertyWalkListenerRunner) {
        JsonSchema propertySchema = entry.getValue();
        JsonNode propertyNode = node == null ? null : node.get(entry.getKey());
        boolean executeWalk = propertyWalkListenerRunner.runPreWalkListeners(ValidatorTypeCode.PROPERTIES.getValue(), propertyNode, rootNode, this.atPath(at, entry.getKey()), propertySchema.getSchemaPath(), propertySchema.getSchemaNode(), propertySchema.getParentSchema(), this.validationContext, this.validationContext.getJsonSchemaFactory());
        if (executeWalk) {
            validationMessages.addAll(propertySchema.walk(propertyNode, rootNode, this.atPath(at, entry.getKey()), shouldValidateSchema));
        }
        propertyWalkListenerRunner.runPostWalkListeners(ValidatorTypeCode.PROPERTIES.getValue(), propertyNode, rootNode, this.atPath(at, entry.getKey()), propertySchema.getSchemaPath(), propertySchema.getSchemaNode(), propertySchema.getParentSchema(), this.validationContext, this.validationContext.getJsonSchemaFactory(), validationMessages);
    }

    public Map<String, JsonSchema> getSchemas() {
        return this.schemas;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas.values());
    }
}

