/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.filemaker;

import com.github.tomakehurst.wiremock.common.filemaker.FilenameTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.text.Normalizer;
import java.util.Collections;
import java.util.Locale;
import java.util.regex.Pattern;
import wiremock.org.apache.commons.lang3.StringUtils;

public class FilenameMaker {
    public static final String DEFAULT_FILENAME_TEMPLATE = "{{#if name}}{{{name}}}{{else}}{{{method}}}-{{{url}}}{{/if}}-{{{id}}}";
    private static final Pattern NON_ALPHANUMERIC = Pattern.compile("[^\\w-.]");
    private static final String DEFAULT_EXTENSION = ".json";
    private static final String POINT = ".";
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");
    private final TemplateEngine templateEngine = new TemplateEngine(Collections.emptyMap(), null, Collections.emptySet());
    private final String filenameTemplate;

    public FilenameMaker() {
        this.filenameTemplate = "{{#if name}}{{{name}}}{{else}}{{{method}}}-{{{url}}}{{/if}}-{{{id}}}.json";
    }

    public FilenameMaker(String filenameTemplate) {
        this.filenameTemplate = filenameTemplate;
    }

    public FilenameMaker(String filenameTemplate, String extension) {
        this.filenameTemplate = filenameTemplate.equals("default") ? "{{#if name}}{{{name}}}{{else}}{{{method}}}-{{{url}}}{{/if}}-{{{id}}}." + extension : filenameTemplate + POINT + extension;
    }

    public String filenameFor(StubMapping stubMapping) {
        HandlebarsOptimizedTemplate template = this.templateEngine.getUncachedTemplate(this.filenameTemplate);
        FilenameTemplateModel templateModel = new FilenameTemplateModel(stubMapping);
        String parsedFilename = template.apply(templateModel);
        return this.sanitise(parsedFilename);
    }

    public String sanitizeUrl(String url) {
        String startingPath = url.replace("/", "_");
        String pathWithoutWhitespace = WHITESPACE.matcher(startingPath).replaceAll("-");
        String normalizedPath = Normalizer.normalize(pathWithoutWhitespace, Normalizer.Form.NFD);
        String slug = this.sanitise(normalizedPath).replaceAll("^[_]*", "").replaceAll("[_]*$", "");
        slug = StringUtils.truncate(slug, 200);
        return slug;
    }

    private String sanitise(String s2) {
        String decoratedString = String.join((CharSequence)"-", s2.split(" "));
        return NON_ALPHANUMERIC.matcher(decoratedString).replaceAll("").toLowerCase(Locale.ROOT);
    }
}

