/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wiremock.org.xmlunit.diff.ElementSelector;
import wiremock.org.xmlunit.diff.ElementSelectors;
import wiremock.org.xmlunit.diff.NodeMatcher;
import wiremock.org.xmlunit.util.Linqy;

public class DefaultNodeMatcher
implements NodeMatcher {
    private static final short TEXT = 3;
    private static final short CDATA = 4;
    private final ElementSelector[] elementSelectors;
    private final NodeTypeMatcher nodeTypeMatcher;

    public DefaultNodeMatcher() {
        this(ElementSelectors.Default);
    }

    public DefaultNodeMatcher(ElementSelector ... es) {
        this(new DefaultNodeTypeMatcher(), es);
    }

    public DefaultNodeMatcher(NodeTypeMatcher ntm, ElementSelector ... es) {
        this.nodeTypeMatcher = ntm;
        this.elementSelectors = es;
    }

    @Override
    public Iterable<Map.Entry<Node, Node>> match(Iterable<Node> controlNodes, Iterable<Node> testNodes) {
        LinkedHashMap<Node, Node> matches = new LinkedHashMap<Node, Node>();
        List<Node> controlList = Linqy.asList(controlNodes);
        List<Node> testList = Linqy.asList(testNodes);
        int testSize = testList.size();
        HashSet<Integer> unmatchedTestIndexes = new HashSet<Integer>();
        for (int i = 0; i < testSize; ++i) {
            unmatchedTestIndexes.add(i);
        }
        int controlSize = controlList.size();
        HashSet<Integer> unmatchedControlIndexes = new HashSet<Integer>();
        for (int i = 0; i < controlSize; ++i) {
            unmatchedControlIndexes.add(i);
        }
        for (ElementSelector e : this.elementSelectors) {
            Match lastMatch = new Match(null, -1);
            for (int i = 0; i < controlSize; ++i) {
                Node control;
                Match testMatch;
                if (!unmatchedControlIndexes.contains(i) || (testMatch = this.findMatchingNode(control = controlList.get(i), testList, lastMatch.index, unmatchedTestIndexes, e)) == null) continue;
                unmatchedControlIndexes.remove(i);
                unmatchedTestIndexes.remove(testMatch.index);
                matches.put(control, testMatch.node);
            }
        }
        return matches.entrySet();
    }

    private Match findMatchingNode(Node searchFor, List<Node> searchIn, int indexOfLastMatch, Set<Integer> availableIndexes, ElementSelector e) {
        int searchSize = searchIn.size();
        Match m3 = this.searchIn(searchFor, searchIn, availableIndexes, indexOfLastMatch + 1, searchSize, e);
        return m3 != null ? m3 : this.searchIn(searchFor, searchIn, availableIndexes, 0, indexOfLastMatch, e);
    }

    private Match searchIn(Node searchFor, List<Node> searchIn, Set<Integer> availableIndexes, int fromInclusive, int toExclusive, ElementSelector e) {
        for (int i = fromInclusive; i < toExclusive; ++i) {
            if (!availableIndexes.contains(i) || !this.nodesMatch(searchFor, searchIn.get(i), e)) continue;
            return new Match(searchIn.get(i), i);
        }
        return null;
    }

    private boolean nodesMatch(Node n1, Node n2, ElementSelector elementSelector) {
        if (n1 instanceof Element && n2 instanceof Element) {
            return elementSelector.canBeCompared((Element)n1, (Element)n2);
        }
        return this.nodeTypeMatcher.canBeCompared(n1.getNodeType(), n2.getNodeType());
    }

    public static class DefaultNodeTypeMatcher
    implements NodeTypeMatcher {
        @Override
        public boolean canBeCompared(short controlType, short testType) {
            return controlType == testType || controlType == 4 && testType == 3 || controlType == 3 && testType == 4;
        }
    }

    public static interface NodeTypeMatcher {
        public boolean canBeCompared(short var1, short var2);
    }

    private static class Match {
        private final Node node;
        private final int index;

        private Match(Node match, int index) {
            this.node = match;
            this.index = index;
        }
    }
}

