/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.ArrayList;
import wiremock.jakarta.servlet.RequestDispatcher;
import wiremock.jakarta.servlet.ServletException;
import wiremock.jakarta.servlet.http.HttpServlet;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.jakarta.servlet.http.HttpServletResponse;
import wiremock.org.eclipse.jetty.util.URIUtil;

@Deprecated
public class ConcatServlet
extends HttpServlet {
    private boolean _development;
    private long _lastModified;

    @Override
    public void init() throws ServletException {
        this._lastModified = System.currentTimeMillis();
        this._development = Boolean.parseBoolean(this.getInitParameter("development"));
    }

    @Override
    protected long getLastModified(HttpServletRequest req) {
        return this._development ? -1L : this._lastModified;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String query = request.getQueryString();
        if (query == null) {
            response.sendError(204);
            return;
        }
        ArrayList<RequestDispatcher> dispatchers = new ArrayList<RequestDispatcher>();
        String[] parts = query.split("\\&");
        String type = null;
        for (String part : parts) {
            RequestDispatcher dispatcher;
            String path = URIUtil.canonicalPath(URIUtil.decodePath(part));
            if (path == null) {
                response.sendError(404);
                return;
            }
            if (this.startsWith(path, "/WEB-INF/") || this.startsWith(path, "/META-INF/")) {
                response.sendError(404);
                return;
            }
            String t = this.getServletContext().getMimeType(path);
            if (t != null) {
                if (type == null) {
                    type = t;
                } else if (!type.equals(t)) {
                    response.sendError(415);
                    return;
                }
            }
            if ((dispatcher = this.getServletContext().getRequestDispatcher(part)) == null) continue;
            dispatchers.add(dispatcher);
        }
        if (type != null) {
            response.setContentType(type);
        }
        for (RequestDispatcher dispatcher : dispatchers) {
            dispatcher.include(request, response);
        }
    }

    private boolean startsWith(String path, String prefix) {
        return prefix.regionMatches(true, 0, path, 0, prefix.length());
    }
}

