/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.internal;

import wiremock.net.javacrumbs.jsonunit.core.Configuration;
import wiremock.net.javacrumbs.jsonunit.core.internal.JsonUtils;
import wiremock.net.javacrumbs.jsonunit.core.internal.Node;
import wiremock.net.javacrumbs.jsonunit.core.internal.Path;

class Context {
    private final Node expectedNode;
    private final Node actualNode;
    private final Path expectedPath;
    private final Path actualPath;
    private final Configuration configuration;

    Context(Node expectedNode, Node actualNode, Path expectedPath, Path actualPath, Configuration configuration) {
        this.expectedNode = expectedNode;
        this.actualNode = actualNode;
        this.expectedPath = expectedPath;
        this.actualPath = actualPath;
        this.configuration = configuration;
    }

    Node getExpectedNode() {
        return this.expectedNode;
    }

    Node getActualNode() {
        return this.actualNode;
    }

    Path getExpectedPath() {
        return this.expectedPath;
    }

    Path getActualPath() {
        return this.actualPath;
    }

    Context inField(String key) {
        return new Context(this.expectedNode.get(key), this.actualNode.get(key), this.expectedPath.toField(key), this.actualPath.toField(key), this.configuration);
    }

    Context toElement(int i) {
        return new Context(this.expectedNode.element(i), this.actualNode.element(i), this.expectedPath.toElement(i), this.actualPath.toElement(i), this.configuration);
    }

    Context missingElement(int i) {
        return new Context(this.expectedNode.element(i), null, this.expectedPath.toElement(i), null, this.configuration);
    }

    Context extraElement(int i) {
        return new Context(null, this.actualNode.element(i), null, this.actualPath.toElement(i), this.configuration);
    }

    Context length(Object expectedLength) {
        return new Context(JsonUtils.wrapDeserializedObject(expectedLength), JsonUtils.wrapDeserializedObject(this.actualNode.size()), this.expectedPath.length(), this.actualPath.length(), this.configuration);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

