/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty11;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.jakarta.servlet.http.HttpServletRequest;
import wiremock.org.eclipse.jetty.proxy.ConnectHandler;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.util.Promise;

public class ManInTheMiddleSslConnectHandler
extends ConnectHandler {
    private final ServerConnector mitmProxyConnector;

    public ManInTheMiddleSslConnectHandler(ServerConnector mitmProxyConnector) {
        this.mitmProxyConnector = mitmProxyConnector;
    }

    @Override
    protected void connectToServer(HttpServletRequest request, String ignoredHost, int ignoredPort, Promise<SocketChannel> promise) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.socket().setTcpNoDelay(true);
            channel.configureBlocking(false);
            String host = MoreObjects.firstNonNull(this.mitmProxyConnector.getHost(), "localhost");
            int port = this.mitmProxyConnector.getLocalPort();
            InetSocketAddress address = this.newConnectAddress(host, port);
            channel.connect(address);
            promise.succeeded(channel);
        }
        catch (Throwable x) {
            this.close(channel);
            promise.failed(x);
        }
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

