/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store.files;

import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.store.BlobStore;
import java.io.InputStream;

public class BlobStoreBinaryFile
extends BinaryFile {
    private final BlobStore blobStore;
    private final String path;

    public BlobStoreBinaryFile(BlobStore blobStore, String path) {
        super(null);
        this.blobStore = blobStore;
        this.path = path;
    }

    @Override
    public byte[] readContents() {
        return (byte[])this.blobStore.get(this.path).orElseThrow(() -> new NotFoundException(this.path + " not found"));
    }

    @Override
    public String name() {
        return this.path;
    }

    @Override
    public String toString() {
        return this.name();
    }

    @Override
    public InputStream getStream() {
        return this.blobStore.getStream(this.path).orElseThrow(() -> new NotFoundException(this.path + " not found"));
    }
}

