/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.SilentErrorHandler;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import wiremock.com.fasterxml.jackson.annotation.JsonGetter;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.org.custommonkey.xmlunit.SimpleNamespaceContext;
import wiremock.org.custommonkey.xmlunit.XMLUnit;
import wiremock.org.custommonkey.xmlunit.XpathEngine;
import wiremock.org.custommonkey.xmlunit.exceptions.XpathException;

public class MatchesXPathPattern
extends StringValuePattern {
    private final Map<String, String> xpathNamespaces;

    public MatchesXPathPattern(@JsonProperty(value="matchesXPath") String expectedValue, @JsonProperty(value="namespaces") Map<String, String> namespaces) {
        super(expectedValue);
        this.xpathNamespaces = namespaces == null || namespaces.isEmpty() ? null : namespaces;
    }

    public MatchesXPathPattern withXPathNamespace(String name, String namespaceUri) {
        ImmutableMap<String, String> namespaceMap = ImmutableMap.builder().putAll(MoreObjects.firstNonNull(this.xpathNamespaces, Collections.emptyMap())).put(name, namespaceUri).build();
        return new MatchesXPathPattern((String)this.expectedValue, namespaceMap);
    }

    public String getMatchesXPath() {
        return (String)this.expectedValue;
    }

    @JsonGetter(value="xPathNamespaces")
    public Map<String, String> getXPathNamespaces() {
        return this.xpathNamespaces;
    }

    @Override
    public MatchResult match(String value) {
        return MatchResult.of(this.isXPathMatch(value));
    }

    private boolean isXPathMatch(String value) {
        if (value == null) {
            return false;
        }
        try {
            NodeList nodeList;
            DocumentBuilder documentBuilder = XMLUnit.newControlParser();
            documentBuilder.setErrorHandler(new SilentErrorHandler());
            Document inDocument = XMLUnit.buildDocument(documentBuilder, new StringReader(value));
            XpathEngine simpleXpathEngine = XMLUnit.newXpathEngine();
            if (this.xpathNamespaces != null) {
                SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext(this.xpathNamespaces);
                simpleXpathEngine.setNamespaceContext(namespaceContext);
            }
            return (nodeList = simpleXpathEngine.getMatchingNodes((String)this.expectedValue, inDocument)).getLength() > 0;
        }
        catch (SAXException e) {
            LocalNotifier.notifier().info(String.format("Warning: failed to parse the XML document. Reason: %s\nXML: %s", e.getMessage(), value));
            return false;
        }
        catch (IOException e) {
            LocalNotifier.notifier().info(e.getMessage());
            return false;
        }
        catch (XpathException e) {
            LocalNotifier.notifier().info("Warning: failed to evaluate the XPath expression " + (String)this.expectedValue);
            return false;
        }
    }
}

