/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.cache;

import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.commons.lang3.Validate;
import wiremock.org.apache.commons.lang3.tuple.Pair;

public class ConcurrentMapTemplateCache
implements TemplateCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<TemplateSource, Pair<TemplateSource, Template>> cache;
    private boolean reload;

    protected ConcurrentMapTemplateCache(ConcurrentMap<TemplateSource, Pair<TemplateSource, Template>> cache) {
        this.cache = Validate.notNull(cache, "The cache is required.", new Object[0]);
    }

    public ConcurrentMapTemplateCache() {
        this(new ConcurrentHashMap<TemplateSource, Pair<TemplateSource, Template>>());
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void evict(TemplateSource source) {
        this.cache.remove(source);
    }

    @Override
    public Template get(TemplateSource source, Parser parser) throws IOException {
        Validate.notNull(source, "The source is required.", new Object[0]);
        Validate.notNull(parser, "The parser is required.", new Object[0]);
        return this.cacheGet(source, parser);
    }

    @Override
    public ConcurrentMapTemplateCache setReload(boolean reload) {
        this.reload = reload;
        return this;
    }

    private Template cacheGet(TemplateSource source, Parser parser) throws IOException {
        Pair<TemplateSource, Template> entry = (Pair<TemplateSource, Template>)this.cache.get(source);
        if (entry == null) {
            this.logger.debug("Loading: {}", (Object)source);
            entry = Pair.of(source, parser.parse(source));
            this.cache.put(source, entry);
        } else if (this.reload && source.lastModified() != ((TemplateSource)entry.getKey()).lastModified()) {
            this.evict(source);
            this.logger.debug("Reloading: {}", (Object)source);
            entry = Pair.of(source, parser.parse(source));
            this.cache.put(source, entry);
        } else {
            this.logger.debug("Found in cache: {}", (Object)source);
        }
        return (Template)entry.getValue();
    }
}

