/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.common.VeryShortIdGenerator;
import com.github.tomakehurst.wiremock.standalone.MappingsSource;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.Iterables;

public class JsonFileMappingsSource
implements MappingsSource {
    private final FileSource mappingsFileSource;
    private final VeryShortIdGenerator idGenerator;
    private final Map<UUID, String> fileNameMap;

    public JsonFileMappingsSource(FileSource mappingsFileSource) {
        this.mappingsFileSource = mappingsFileSource;
        this.idGenerator = new VeryShortIdGenerator();
        this.fileNameMap = new HashMap<UUID, String>();
    }

    @Override
    public void save(List<StubMapping> stubMappings) {
        for (StubMapping mapping : stubMappings) {
            if (mapping == null || !mapping.isDirty()) continue;
            this.save(mapping);
        }
    }

    @Override
    public void save(StubMapping stubMapping) {
        String mappingFileName = this.fileNameMap.get(stubMapping.getId());
        if (mappingFileName == null) {
            mappingFileName = "saved-mapping-" + this.idGenerator.generate() + ".json";
        }
        this.mappingsFileSource.writeTextFile(mappingFileName, Json.write(stubMapping));
        this.fileNameMap.put(stubMapping.getId(), mappingFileName);
        stubMapping.setDirty(false);
    }

    @Override
    public void remove(StubMapping stubMapping) {
        String mappingFileName = this.fileNameMap.get(stubMapping.getId());
        this.mappingsFileSource.deleteFile(mappingFileName);
        this.fileNameMap.remove(stubMapping.getId());
    }

    @Override
    public void loadMappingsInto(StubMappings stubMappings) {
        if (!this.mappingsFileSource.exists()) {
            return;
        }
        Iterable<TextFile> mappingFiles = Iterables.filter(this.mappingsFileSource.listFilesRecursively(), this.byFileExtension("json"));
        for (TextFile mappingFile : mappingFiles) {
            StubMapping mapping = StubMapping.buildFrom(mappingFile.readContentsAsString());
            mapping.setDirty(false);
            stubMappings.addMapping(mapping);
            this.fileNameMap.put(mapping.getId(), this.getFileName(mappingFile));
        }
    }

    private Predicate<TextFile> byFileExtension(final String extension) {
        return new Predicate<TextFile>(){

            @Override
            public boolean apply(TextFile input) {
                return input.name().endsWith("." + extension);
            }
        };
    }

    private String getFileName(TextFile mappingFile) {
        return mappingFile.getUri().toString().replaceAll("^.*/", "");
    }
}

