/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.Objects;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.org.apache.commons.lang3.StringUtils;

public class EqualToPattern
extends StringValuePattern {
    public EqualToPattern(@JsonProperty(value="equalTo") String testValue) {
        super(testValue);
    }

    public String getEqualTo() {
        return this.expectedValue;
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return Objects.equals(EqualToPattern.this.expectedValue, value);
            }

            @Override
            public double getDistance() {
                return EqualToPattern.this.normalisedLevenshteinDistance(EqualToPattern.this.expectedValue, value);
            }
        };
    }

    private double normalisedLevenshteinDistance(String one, String two) {
        if (one == null || two == null) {
            return 1.0;
        }
        double maxDistance = Math.max(one.length(), two.length());
        double actualDistance = StringUtils.getLevenshteinDistance(one, two);
        return actualDistance / maxDistance;
    }
}

