/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty9.CustomizedSslContextFactory;
import com.github.tomakehurst.wiremock.jetty9.JettyFaultInjectorFactory;
import com.github.tomakehurst.wiremock.servlet.ContentTypeSettingFilter;
import com.github.tomakehurst.wiremock.servlet.TrailingSlashFilter;
import com.github.tomakehurst.wiremock.servlet.WireMockHandlerDispatchingServlet;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.io.Resources;
import wiremock.org.eclipse.jetty.http.MimeTypes;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.HttpConnectionFactory;
import wiremock.org.eclipse.jetty.server.SecureRequestCustomizer;
import wiremock.org.eclipse.jetty.server.Server;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.server.SslConnectionFactory;
import wiremock.org.eclipse.jetty.server.handler.HandlerCollection;
import wiremock.org.eclipse.jetty.servlet.DefaultServlet;
import wiremock.org.eclipse.jetty.servlet.FilterHolder;
import wiremock.org.eclipse.jetty.servlet.ServletContextHandler;
import wiremock.org.eclipse.jetty.servlet.ServletHolder;
import wiremock.org.eclipse.jetty.servlets.CrossOriginFilter;
import wiremock.org.eclipse.jetty.servlets.GzipFilter;
import wiremock.org.eclipse.jetty.util.thread.QueuedThreadPool;

class JettyHttpServer
implements HttpServer {
    private static final String FILES_URL_MATCH = String.format("/%s/*", "__files");
    private final Server jettyServer;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;

    JettyHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        QueuedThreadPool threadPool = new QueuedThreadPool(options.containerThreads());
        this.jettyServer = new Server(threadPool);
        this.httpConnector = this.createHttpConnector(options.bindAddress(), options.portNumber(), options.jettySettings());
        this.jettyServer.addConnector(this.httpConnector);
        if (options.httpsSettings().enabled()) {
            this.httpsConnector = this.createHttpsConnector(options.httpsSettings(), options.jettySettings());
            this.jettyServer.addConnector(this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        Notifier notifier = options.notifier();
        ServletContextHandler adminContext = this.addAdminContext(adminRequestHandler, notifier);
        ServletContextHandler mockServiceContext = this.addMockServiceContext(stubRequestHandler, options.filesRoot(), notifier);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{adminContext, mockServiceContext});
        this.jettyServer.setHandler(handlers);
        this.jettyServer.setStopTimeout(0L);
    }

    @Override
    public void start() {
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.jettyServer.isStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= timeout) continue;
            throw new RuntimeException("Server took too long to start up.");
        }
    }

    @Override
    public void stop() {
        try {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            Exceptions.throwUnchecked(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.jettyServer.isRunning();
    }

    @Override
    public int port() {
        return this.httpConnector.getLocalPort();
    }

    @Override
    public int httpsPort() {
        return this.httpsConnector.getLocalPort();
    }

    private ServerConnector createHttpConnector(String bindAddress, int port, JettySettings jettySettings) {
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        ServerConnector connector = this.createServerConnector(jettySettings, port, new HttpConnectionFactory(httpConfig));
        connector.setHost(bindAddress);
        return connector;
    }

    private ServerConnector createHttpsConnector(HttpsSettings httpsSettings, JettySettings jettySettings) {
        CustomizedSslContextFactory sslContextFactory = new CustomizedSslContextFactory();
        sslContextFactory.setKeyStorePath(httpsSettings.keyStorePath());
        sslContextFactory.setKeyManagerPassword(httpsSettings.keyStorePassword());
        sslContextFactory.setKeyStoreType(httpsSettings.keyStoreType());
        if (httpsSettings.hasTrustStore()) {
            sslContextFactory.setTrustStorePath(httpsSettings.trustStorePath());
            sslContextFactory.setTrustStorePassword(httpsSettings.trustStorePassword());
            sslContextFactory.setTrustStoreType(httpsSettings.trustStoreType());
        }
        sslContextFactory.setNeedClientAuth(httpsSettings.needClientAuth());
        HttpConfiguration httpConfig = this.createHttpConfig(jettySettings);
        httpConfig.addCustomizer(new SecureRequestCustomizer());
        int port = httpsSettings.port();
        return this.createServerConnector(jettySettings, port, new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpConfig));
    }

    private HttpConfiguration createHttpConfig(JettySettings jettySettings) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(jettySettings.getRequestHeaderSize().or(8192));
        httpConfig.setSendDateHeader(false);
        return httpConfig;
    }

    private ServerConnector createServerConnector(JettySettings jettySettings, int port, ConnectionFactory ... connectionFactories) {
        int acceptors = jettySettings.getAcceptors().or(2);
        ServerConnector connector = new ServerConnector(this.jettyServer, null, null, null, acceptors, 2, connectionFactories);
        connector.setPort(port);
        connector.setStopTimeout(0L);
        connector.getSelectorManager().setStopTimeout(0L);
        this.setJettySettings(jettySettings, connector);
        return connector;
    }

    private void setJettySettings(JettySettings jettySettings, ServerConnector connector) {
        if (jettySettings.getAcceptQueueSize().isPresent()) {
            connector.setAcceptQueueSize(jettySettings.getAcceptQueueSize().get());
        }
    }

    private ServletContextHandler addMockServiceContext(StubRequestHandler stubRequestHandler, FileSource fileSource, Notifier notifier) {
        ServletContextHandler mockServiceContext = new ServletContextHandler(this.jettyServer, "/");
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.resourceBase", fileSource.getPath());
        mockServiceContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        mockServiceContext.addServlet(DefaultServlet.class, FILES_URL_MATCH);
        mockServiceContext.setAttribute(JettyFaultInjectorFactory.class.getName(), new JettyFaultInjectorFactory());
        mockServiceContext.setAttribute(StubRequestHandler.class.getName(), stubRequestHandler);
        mockServiceContext.setAttribute("Notifier", notifier);
        ServletHolder servletHolder = mockServiceContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", StubRequestHandler.class.getName());
        servletHolder.setInitParameter("FaultHandlerFactoryClass", JettyFaultInjectorFactory.class.getName());
        servletHolder.setInitParameter("shouldForwardToFilesContext", "true");
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("json", "application/json");
        mimeTypes.addMimeMapping("html", "text/html");
        mimeTypes.addMimeMapping("xml", "application/xml");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mockServiceContext.setMimeTypes(mimeTypes);
        mockServiceContext.setWelcomeFiles(new String[]{"index.json", "index.html", "index.xml", "index.txt"});
        mockServiceContext.addFilter(GzipFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD));
        mockServiceContext.addFilter(ContentTypeSettingFilter.class, FILES_URL_MATCH, EnumSet.of(DispatcherType.FORWARD));
        mockServiceContext.addFilter(TrailingSlashFilter.class, FILES_URL_MATCH, EnumSet.allOf(DispatcherType.class));
        return mockServiceContext;
    }

    private ServletContextHandler addAdminContext(AdminRequestHandler adminRequestHandler, Notifier notifier) {
        ServletContextHandler adminContext = new ServletContextHandler(this.jettyServer, "/__admin");
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.maxCacheSize", "0");
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.resourceBase", Resources.getResource("assets").toString());
        adminContext.setInitParameter("wiremock.org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        adminContext.addServlet(DefaultServlet.class, "/swagger-ui/*");
        ServletHolder servletHolder = adminContext.addServlet(WireMockHandlerDispatchingServlet.class, "/");
        servletHolder.setInitParameter("RequestHandlerClass", AdminRequestHandler.class.getName());
        adminContext.setAttribute(AdminRequestHandler.class.getName(), adminRequestHandler);
        adminContext.setAttribute("Notifier", notifier);
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameters(ImmutableMap.of("chainPreflight", "false", "allowedOrigins", "*", "allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin,Authorization", "allowedMethods", "OPTIONS,GET,POST,PUT,PATCH,DELETE"));
        adminContext.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        return adminContext;
    }
}

