/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.LimitAndOffsetPaginator;
import com.github.tomakehurst.wiremock.admin.model.GetServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.SingleServedStubResult;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.InMemoryStubMappings;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.DisabledRequestJournal;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.InMemoryRequestJournal;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.NearMissCalculator;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.RequestJournalDisabledException;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.ImmutableList;

public class WireMockApp
implements StubServer,
Admin {
    public static final String FILES_ROOT = "__files";
    public static final String ADMIN_CONTEXT_ROOT = "/__admin";
    public static final String MAPPINGS_ROOT = "mappings";
    private final StubMappings stubMappings;
    private final RequestJournal requestJournal;
    private final GlobalSettingsHolder globalSettingsHolder;
    private final boolean browserProxyingEnabled;
    private final MappingsLoader defaultMappingsLoader;
    private final Container container;
    private final MappingsSaver mappingsSaver;
    private final NearMissCalculator nearMissCalculator;
    private Options options;

    public WireMockApp(Options options, Container container) {
        this.options = options;
        FileSource fileSource = options.filesRoot();
        this.browserProxyingEnabled = options.browserProxyingEnabled();
        this.defaultMappingsLoader = options.mappingsLoader();
        this.mappingsSaver = options.mappingsSaver();
        this.globalSettingsHolder = new GlobalSettingsHolder();
        this.requestJournal = options.requestJournalDisabled() ? new DisabledRequestJournal() : new InMemoryRequestJournal(options.maxRequestJournalEntries());
        this.stubMappings = new InMemoryStubMappings(options.extensionsOfType(RequestMatcherExtension.class), options.extensionsOfType(ResponseDefinitionTransformer.class), fileSource);
        this.nearMissCalculator = new NearMissCalculator(this.stubMappings, this.requestJournal);
        this.container = container;
        this.loadDefaultMappings();
    }

    public WireMockApp(boolean browserProxyingEnabled, MappingsLoader defaultMappingsLoader, MappingsSaver mappingsSaver, boolean requestJournalDisabled, Optional<Integer> maxRequestJournalEntries, Map<String, ResponseDefinitionTransformer> transformers, Map<String, RequestMatcherExtension> requestMatchers, FileSource rootFileSource, Container container) {
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.defaultMappingsLoader = defaultMappingsLoader;
        this.mappingsSaver = mappingsSaver;
        this.globalSettingsHolder = new GlobalSettingsHolder();
        this.requestJournal = requestJournalDisabled ? new DisabledRequestJournal() : new InMemoryRequestJournal(maxRequestJournalEntries);
        this.stubMappings = new InMemoryStubMappings(requestMatchers, transformers, rootFileSource);
        this.container = container;
        this.nearMissCalculator = new NearMissCalculator(this.stubMappings, this.requestJournal);
        this.loadDefaultMappings();
    }

    public AdminRequestHandler buildAdminRequestHandler() {
        AdminRoutes adminRoutes = AdminRoutes.defaultsPlus(this.options.extensionsOfType(AdminApiExtension.class).values());
        return new AdminRequestHandler(adminRoutes, this, new BasicResponseRenderer());
    }

    public StubRequestHandler buildStubRequestHandler() {
        Map<String, PostServeAction> postServeActions = this.options.extensionsOfType(PostServeAction.class);
        return new StubRequestHandler(this, new StubResponseRenderer(this.options.filesRoot().child(FILES_ROOT), this.getGlobalSettingsHolder(), new ProxyResponseRenderer(this.options.proxyVia(), this.options.httpsSettings().trustStore(), this.options.shouldPreserveHostHeader(), this.options.proxyHostHeader()), ImmutableList.copyOf(this.options.extensionsOfType(ResponseTransformer.class).values())), this, postServeActions, this.requestJournal);
    }

    public GlobalSettingsHolder getGlobalSettingsHolder() {
        return this.globalSettingsHolder;
    }

    private void loadDefaultMappings() {
        this.loadMappingsUsing(this.defaultMappingsLoader);
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        mappingsLoader.loadMappingsInto(this.stubMappings);
    }

    @Override
    public ServeEvent serveStubFor(Request request) {
        ServeEvent serveEvent = this.stubMappings.serveFor(request);
        if (serveEvent.isNoExactMatch()) {
            LoggedRequest loggedRequest = LoggedRequest.createFrom(request);
            if (request.isBrowserProxyRequest() && this.browserProxyingEnabled) {
                return ServeEvent.of(loggedRequest, ResponseDefinition.browserProxy(request));
            }
            this.logUnmatchedRequest(loggedRequest);
        }
        return serveEvent;
    }

    private void logUnmatchedRequest(LoggedRequest request) {
        List<NearMiss> nearest = this.nearMissCalculator.findNearestTo(request);
        String message = "Request was not matched:\n" + request;
        if (!nearest.isEmpty()) {
            message = message + "\nClosest match:\n" + nearest.get(0).getStubMapping().getRequest();
        }
        LocalNotifier.notifier().error(message);
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        this.stubMappings.addMapping(stubMapping);
        if (stubMapping.shouldBePersisted()) {
            this.mappingsSaver.save(stubMapping);
        }
    }

    @Override
    public void removeStubMapping(StubMapping stubMapping) {
        this.stubMappings.removeMapping(stubMapping);
        if (stubMapping.shouldBePersisted()) {
            this.mappingsSaver.remove(stubMapping);
        }
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.stubMappings.editMapping(stubMapping);
        if (stubMapping.shouldBePersisted()) {
            this.mappingsSaver.save(stubMapping);
        }
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return new ListStubMappingsResult(LimitAndOffsetPaginator.none(this.stubMappings.getAll()));
    }

    @Override
    public SingleStubMappingResult getStubMapping(UUID id) {
        return SingleStubMappingResult.fromOptional(this.stubMappings.get(id));
    }

    @Override
    public void saveMappings() {
        this.mappingsSaver.save(this.stubMappings.getAll());
    }

    @Override
    public void resetAll() {
        this.stubMappings.reset();
        this.requestJournal.reset();
    }

    @Override
    public void resetRequests() {
        this.requestJournal.reset();
    }

    @Override
    public void resetToDefaultMappings() {
        this.resetAll();
        this.loadDefaultMappings();
    }

    @Override
    public void resetScenarios() {
        this.stubMappings.resetScenarios();
    }

    @Override
    public void resetMappings() {
        this.stubMappings.reset();
    }

    @Override
    public GetServeEventsResult getServeEvents() {
        try {
            return GetServeEventsResult.requestJournalEnabled(LimitAndOffsetPaginator.none(this.requestJournal.getAllServeEvents()));
        }
        catch (RequestJournalDisabledException e) {
            return GetServeEventsResult.requestJournalDisabled(LimitAndOffsetPaginator.none(this.requestJournal.getAllServeEvents()));
        }
    }

    @Override
    public SingleServedStubResult getServedStub(UUID id) {
        return SingleServedStubResult.fromOptional(this.requestJournal.getServeEvent(id));
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        try {
            return VerificationResult.withCount(this.requestJournal.countRequestsMatching(requestPattern));
        }
        catch (RequestJournalDisabledException e) {
            return VerificationResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        try {
            List<LoggedRequest> requests = this.requestJournal.getRequestsMatching(requestPattern);
            return FindRequestsResult.withRequests(requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        try {
            ImmutableList<LoggedRequest> requests = FluentIterable.from(this.requestJournal.getAllServeEvents()).filter(ServeEvent.NOT_MATCHED).transform(ServeEvent.TO_LOGGED_REQUEST).toList();
            return FindRequestsResult.withRequests(requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        FluentIterable<ServeEvent> unmatchedServeEvents = FluentIterable.from(this.requestJournal.getAllServeEvents()).filter(new Predicate<ServeEvent>(){

            @Override
            public boolean apply(ServeEvent input) {
                return input.isNoExactMatch();
            }
        });
        for (ServeEvent serveEvent : unmatchedServeEvents) {
            listBuilder.addAll(this.nearMissCalculator.findNearestTo(serveEvent.getRequest()));
        }
        return new FindNearMissesResult((List<NearMiss>)((Object)listBuilder.build()));
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        return new FindNearMissesResult(this.nearMissCalculator.findNearestTo(loggedRequest));
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        return new FindNearMissesResult(this.nearMissCalculator.findNearestTo(requestPattern));
    }

    @Override
    public void updateGlobalSettings(GlobalSettings newSettings) {
        this.globalSettingsHolder.replaceWith(newSettings);
    }

    public int port() {
        return this.container.port();
    }

    @Override
    public void shutdownServer() {
        this.container.shutdown();
    }
}

