/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.SystemKeyAuthoriser;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateCacheKey;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SystemValueHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import wiremock.com.github.jknack.handlebars.Handlebars;
import wiremock.com.github.jknack.handlebars.Helper;
import wiremock.com.github.jknack.handlebars.helper.AssignHelper;
import wiremock.com.github.jknack.handlebars.helper.ConditionalHelpers;
import wiremock.com.github.jknack.handlebars.helper.NumberHelper;
import wiremock.com.github.jknack.handlebars.helper.StringHelpers;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.cache.Cache;
import wiremock.com.google.common.cache.CacheBuilder;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.collect.ImmutableSet;
import wiremock.com.google.common.collect.Iterables;

public class ResponseTemplateTransformer
extends ResponseDefinitionTransformer
implements StubLifecycleListener {
    public static final String NAME = "response-template";
    private final boolean global;
    private final Handlebars handlebars;
    private final Cache<TemplateCacheKey, HandlebarsOptimizedTemplate> cache;
    private final Long maxCacheEntries;

    public static Builder builder() {
        return new Builder();
    }

    public ResponseTemplateTransformer(boolean global) {
        this(global, Collections.emptyMap());
    }

    public ResponseTemplateTransformer(boolean global, String helperName, Helper helper) {
        this(global, ImmutableMap.of(helperName, helper));
    }

    public ResponseTemplateTransformer(boolean global, Map<String, Helper> helpers) {
        this(global, new Handlebars(), helpers, null, null);
    }

    public ResponseTemplateTransformer(boolean global, Handlebars handlebars, Map<String, Helper> helpers, Long maxCacheEntries, Set<String> permittedSystemKeys) {
        this.global = global;
        this.handlebars = handlebars;
        for (StringHelpers stringHelpers : StringHelpers.values()) {
            if (stringHelpers.name().equals("now")) continue;
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (Enum enum_ : NumberHelper.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        for (Enum enum_ : ConditionalHelpers.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        this.handlebars.registerHelper("assign", (Helper)new AssignHelper());
        for (Enum enum_ : WireMockHelpers.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        this.handlebars.registerHelper("systemValue", (Helper)new SystemValueHelper(new SystemKeyAuthoriser(permittedSystemKeys)));
        for (Map.Entry<String, Helper> entry : helpers.entrySet()) {
            this.handlebars.registerHelper(entry.getKey(), entry.getValue());
        }
        this.maxCacheEntries = maxCacheEntries;
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (maxCacheEntries != null) {
            cacheBuilder.maximumSize(maxCacheEntries);
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public boolean applyGlobally() {
        return this.global;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseDefinition transform(Request request, final ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        ResponseDefinitionBuilder newResponseDefBuilder = ResponseDefinitionBuilder.like(responseDefinition);
        final ImmutableMap<String, Object> model = ImmutableMap.builder().put("parameters", MoreObjects.firstNonNull(parameters, Collections.emptyMap())).put("request", (Map<String, RequestTemplateModel>)((Object)RequestTemplateModel.from(request))).putAll(this.addExtraModelElements(request, responseDefinition, files, parameters)).build();
        if (responseDefinition.specifiesTextBodyContent()) {
            HandlebarsOptimizedTemplate bodyTemplate = this.getTemplate(TemplateCacheKey.forInlineBody(responseDefinition), responseDefinition.getTextBody());
            this.applyTemplatedResponseBody(newResponseDefBuilder, model, bodyTemplate);
        } else if (responseDefinition.specifiesBodyFile()) {
            HandlebarsOptimizedTemplate filePathTemplate = new HandlebarsOptimizedTemplate(this.handlebars, responseDefinition.getBodyFileName());
            String compiledFilePath = this.uncheckedApplyTemplate(filePathTemplate, model);
            boolean disableBodyFileTemplating = parameters.getBoolean("disableBodyFileTemplating", false);
            if (disableBodyFileTemplating) {
                newResponseDefBuilder.withBodyFile(compiledFilePath);
            } else {
                TextFile file = files.getTextFileNamed(compiledFilePath);
                HandlebarsOptimizedTemplate bodyTemplate = this.getTemplate(TemplateCacheKey.forFileBody(responseDefinition, compiledFilePath), file.readContentsAsString());
                this.applyTemplatedResponseBody(newResponseDefBuilder, model, bodyTemplate);
            }
        }
        if (responseDefinition.getHeaders() != null) {
            Iterable<HttpHeader> newResponseHeaders = Iterables.transform(responseDefinition.getHeaders().all(), new Function<HttpHeader, HttpHeader>(){

                @Override
                public HttpHeader apply(HttpHeader header) {
                    ImmutableList.Builder valueListBuilder = ImmutableList.builder();
                    int index = 0;
                    for (String headerValue : header.values()) {
                        HandlebarsOptimizedTemplate template = ResponseTemplateTransformer.this.getTemplate(TemplateCacheKey.forHeader(responseDefinition, header.key(), index++), headerValue);
                        valueListBuilder.add(ResponseTemplateTransformer.this.uncheckedApplyTemplate(template, model));
                    }
                    return new HttpHeader(header.key(), (Collection<String>)valueListBuilder.build());
                }
            });
            newResponseDefBuilder.withHeaders(new HttpHeaders(newResponseHeaders));
        }
        if (responseDefinition.getProxyBaseUrl() != null) {
            HandlebarsOptimizedTemplate proxyBaseUrlTemplate = this.getTemplate(TemplateCacheKey.forProxyUrl(responseDefinition), responseDefinition.getProxyBaseUrl());
            String newProxyBaseUrl = this.uncheckedApplyTemplate(proxyBaseUrlTemplate, model);
            newResponseDefBuilder.proxiedFrom(newProxyBaseUrl);
        }
        return newResponseDefBuilder.build();
    }

    protected Map<String, Object> addExtraModelElements(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        return Collections.emptyMap();
    }

    private void applyTemplatedResponseBody(ResponseDefinitionBuilder newResponseDefBuilder, ImmutableMap<String, Object> model, HandlebarsOptimizedTemplate bodyTemplate) {
        String newBody = this.uncheckedApplyTemplate(bodyTemplate, model);
        newResponseDefBuilder.withBody(newBody);
    }

    private String uncheckedApplyTemplate(HandlebarsOptimizedTemplate template, Object context) {
        try {
            return template.apply(context);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private HandlebarsOptimizedTemplate getTemplate(TemplateCacheKey key, final String content) {
        if (this.maxCacheEntries != null && this.maxCacheEntries < 1L) {
            return new HandlebarsOptimizedTemplate(this.handlebars, content);
        }
        try {
            return this.cache.get(key, new Callable<HandlebarsOptimizedTemplate>(){

                @Override
                public HandlebarsOptimizedTemplate call() {
                    return new HandlebarsOptimizedTemplate(ResponseTemplateTransformer.this.handlebars, content);
                }
            });
        }
        catch (ExecutionException e) {
            return Exceptions.throwUnchecked(e, HandlebarsOptimizedTemplate.class);
        }
    }

    @Override
    public void beforeStubCreated(StubMapping stub) {
    }

    @Override
    public void afterStubCreated(StubMapping stub) {
    }

    @Override
    public void beforeStubEdited(StubMapping oldStub, StubMapping newStub) {
    }

    @Override
    public void afterStubEdited(StubMapping oldStub, StubMapping newStub) {
    }

    @Override
    public void beforeStubRemoved(StubMapping stub) {
    }

    @Override
    public void afterStubRemoved(StubMapping stub) {
        this.cache.invalidateAll();
    }

    @Override
    public void beforeStubsReset() {
    }

    @Override
    public void afterStubsReset() {
        this.cache.invalidateAll();
    }

    public long getCacheSize() {
        return this.cache.size();
    }

    public Long getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public static class Builder {
        private boolean global = true;
        private Handlebars handlebars = new Handlebars();
        private Map<String, Helper> helpers = new HashMap<String, Helper>();
        private Long maxCacheEntries = null;
        private Set<String> permittedSystemKeys = null;

        public Builder global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder handlebars(Handlebars handlebars) {
            this.handlebars = handlebars;
            return this;
        }

        public Builder helpers(Map<String, Helper> helpers) {
            this.helpers = helpers;
            return this;
        }

        public Builder helper(String name, Helper helper) {
            this.helpers.put(name, helper);
            return this;
        }

        public Builder maxCacheEntries(Long maxCacheEntries) {
            this.maxCacheEntries = maxCacheEntries;
            return this;
        }

        public Builder permittedSystemKeys(Set<String> keys) {
            this.permittedSystemKeys = keys;
            return this;
        }

        public Builder permittedSystemKeys(String ... keys) {
            this.permittedSystemKeys = ImmutableSet.copyOf(keys);
            return this;
        }

        public ResponseTemplateTransformer build() {
            return new ResponseTemplateTransformer(this.global, this.handlebars, this.helpers, this.maxCacheEntries, this.permittedSystemKeys);
        }
    }
}

