/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.builder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import wiremock.org.xmlunit.XMLUnitException;
import wiremock.org.xmlunit.builder.AbstractTransformationBuilder;
import wiremock.org.xmlunit.builder.JaxbBuilder;
import wiremock.org.xmlunit.builder.TransformationBuilderBase;

public class Input {
    private Input() {
    }

    public static Builder fromDocument(Document d) {
        return new SourceHoldingBuilder(new DOMSource(d));
    }

    public static Builder fromNode(Node n) {
        return new SourceHoldingBuilder(new DOMSource(n));
    }

    public static Builder from(Object object) {
        Builder xml = object instanceof Source ? new SourceHoldingBuilder((Source)object) : (object instanceof Builder ? (Builder)object : (object instanceof Document ? Input.fromDocument((Document)object) : (object instanceof Node ? Input.fromNode((Node)object) : (object instanceof byte[] ? Input.fromByteArray((byte[])object) : (object instanceof String ? Input.fromString((String)object) : (object instanceof File ? Input.fromFile((File)object) : (object instanceof URL ? Input.fromURL((URL)object) : (object instanceof URI ? Input.fromURI((URI)object) : (object instanceof InputStream ? Input.fromStream((InputStream)object) : (object instanceof ReadableByteChannel ? Input.fromChannel((ReadableByteChannel)object) : Input.fromJaxb(object)))))))))));
        return xml;
    }

    public static JaxbBuilder fromJaxb(Object jaxbObject) {
        return new JaxbBuilder(jaxbObject);
    }

    public static Builder fromFile(File f) {
        return new StreamBuilder(f);
    }

    public static Builder fromFile(String name) {
        return new StreamBuilder(new File(name));
    }

    public static Builder fromStream(InputStream s) {
        return new StreamBuilder(s);
    }

    public static Builder fromReader(Reader r) {
        return new StreamBuilder(r);
    }

    public static Builder fromString(String s) {
        return Input.fromReader(new StringReader(s));
    }

    public static Builder fromByteArray(byte[] b) {
        return Input.fromStream(new ByteArrayInputStream(b));
    }

    public static Builder fromChannel(ReadableByteChannel c) {
        return Input.fromStream(Channels.newInputStream(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Builder fromURL(URL url) {
        StreamBuilder streamBuilder;
        block9: {
            InputStream in = null;
            try {
                in = url.openStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int read = -1;
                byte[] buf = new byte[4096];
                while ((read = in.read(buf)) >= 0) {
                    if (read <= 0) continue;
                    baos.write(buf, 0, read);
                }
                StreamBuilder b = (StreamBuilder)Input.fromByteArray(baos.toByteArray());
                try {
                    b.setSystemId(url.toURI().toString());
                }
                catch (URISyntaxException use) {
                    b.setSystemId(url.toString());
                }
                streamBuilder = b;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new XMLUnitException(ex);
                }
            }
            in.close();
        }
        return streamBuilder;
    }

    public static Builder fromURI(URI uri) {
        try {
            return Input.fromURL(uri.toURL());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("uri " + uri + " is not an URL", ex);
        }
    }

    public static Builder fromURI(String uri) {
        try {
            return Input.fromURI(new URI(uri));
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("uri " + uri + " is not an URI", ex);
        }
    }

    public static TransformationBuilder byTransforming(Source s) {
        return new Transformation(s);
    }

    public static TransformationBuilder byTransforming(Builder b) {
        return Input.byTransforming(b.build());
    }

    private static class Transformation
    extends AbstractTransformationBuilder<TransformationBuilder>
    implements TransformationBuilder {
        private Transformation(Source s) {
            super(s);
        }

        @Override
        public TransformationBuilder withStylesheet(Builder b) {
            return (TransformationBuilder)this.withStylesheet(b.build());
        }

        @Override
        public Source build() {
            return new DOMSource(this.getHelper().transformToDocument());
        }
    }

    public static interface TransformationBuilder
    extends TransformationBuilderBase<TransformationBuilder>,
    Builder {
        public TransformationBuilder withStylesheet(Builder var1);
    }

    private static class StreamBuilder
    extends SourceHoldingBuilder {
        private StreamBuilder(File f) {
            super(new StreamSource(f));
        }

        private StreamBuilder(InputStream s) {
            super(new StreamSource(s));
        }

        private StreamBuilder(Reader r) {
            super(new StreamSource(r));
        }

        void setSystemId(String id) {
            if (id != null) {
                this.source.setSystemId(id);
            }
        }
    }

    private static class SourceHoldingBuilder
    implements Builder {
        protected final Source source;

        protected SourceHoldingBuilder(Source source) {
            this.source = source;
        }

        @Override
        public Source build() {
            assert (this.source != null);
            return this.source;
        }
    }

    public static interface Builder {
        public Source build();
    }
}

