/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.flipkart.zjsonpatch;

import java.util.Map;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.collect.ImmutableMap;

enum Operation {
    ADD("add"),
    REMOVE("remove"),
    REPLACE("replace"),
    MOVE("move");

    private static final Map<String, Operation> OPS;
    private String rfcName;

    private Operation(String rfcName) {
        this.rfcName = rfcName;
    }

    public static Operation fromRfcName(String rfcName) {
        Preconditions.checkNotNull(rfcName, "rfcName cannot be null");
        return Preconditions.checkNotNull(OPS.get(rfcName.toLowerCase()), "unknown / unsupported operation %s", rfcName);
    }

    public String rfcName() {
        return this.rfcName;
    }

    static {
        OPS = ImmutableMap.of(Operation.ADD.rfcName, ADD, Operation.REMOVE.rfcName, REMOVE, Operation.REPLACE.rfcName, REPLACE, Operation.MOVE.rfcName, MOVE);
    }
}

