/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestEventSource;
import com.github.tomakehurst.wiremock.http.RequestHandler;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.List;
import java.util.concurrent.TimeUnit;
import wiremock.com.google.common.base.Stopwatch;
import wiremock.com.google.common.collect.Lists;

public abstract class AbstractRequestHandler
implements RequestHandler,
RequestEventSource {
    protected List<RequestListener> listeners = Lists.newArrayList();
    protected final ResponseRenderer responseRenderer;

    public AbstractRequestHandler(ResponseRenderer responseRenderer) {
        this.responseRenderer = responseRenderer;
    }

    @Override
    public void addRequestListener(RequestListener requestListener) {
        this.listeners.add(requestListener);
    }

    protected void beforeResponseSent(ServeEvent serveEvent, Response response) {
    }

    protected void afterResponseSent(ServeEvent serveEvent, Response response) {
    }

    @Override
    public void handle(Request request, HttpResponder httpResponder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ServeEvent serveEvent = this.handleRequest(request);
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        responseDefinition.setOriginalRequest(request);
        Response response = this.responseRenderer.render(serveEvent);
        ServeEvent completedServeEvent = serveEvent.complete(response, (int)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        if (this.logRequests()) {
            LocalNotifier.notifier().info("Request received:\n" + AbstractRequestHandler.formatRequest(request) + "\n\nMatched response definition:\n" + responseDefinition + "\n\nResponse:\n" + response);
        }
        for (RequestListener listener : this.listeners) {
            listener.requestReceived(request, response);
        }
        this.beforeResponseSent(completedServeEvent, response);
        stopwatch.reset();
        stopwatch.start();
        httpResponder.respond(request, response);
        completedServeEvent.afterSend((int)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        this.afterResponseSent(completedServeEvent, response);
        stopwatch.stop();
    }

    private static String formatRequest(Request request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getClientIp()).append(" - ").append(request.getMethod()).append(" ").append(request.getUrl());
        if (request.isBrowserProxyRequest()) {
            sb.append(" (via browser proxy request)");
        }
        sb.append("\n\n");
        sb.append(request.getHeaders());
        if (request.getBody() != null) {
            sb.append(request.getBodyAsString()).append("\n");
        }
        return sb.toString();
    }

    protected boolean logRequests() {
        return false;
    }

    protected abstract ServeEvent handleRequest(Request var1);
}

