/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import com.github.tomakehurst.wiremock.verification.diff.JUnitStyleDiffRenderer;
import com.github.tomakehurst.wiremock.verification.diff.SpacerLine;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import wiremock.com.google.common.base.MoreObjects;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.io.BaseEncoding;

public class Diff {
    private final String stubMappingName;
    private final RequestPattern requestPattern;
    private final Request request;

    public Diff(RequestPattern expected, Request actual) {
        this.requestPattern = expected;
        this.request = actual;
        this.stubMappingName = null;
    }

    public Diff(StubMapping expected, Request actual) {
        this.requestPattern = expected.getRequest();
        this.request = actual;
        this.stubMappingName = expected.getName();
    }

    public String toString() {
        return new JUnitStyleDiffRenderer().render(this);
    }

    public List<DiffLine<?>> getLines() {
        List<ContentPattern<?>> bodyPatterns;
        ImmutableList.Builder builder = ImmutableList.builder();
        DiffLine<RequestMethod> methodSection = new DiffLine<RequestMethod>("HTTP method", this.requestPattern.getMethod(), this.request.getMethod(), this.requestPattern.getMethod().getName());
        builder.add(methodSection);
        DiffLine<String> urlSection = new DiffLine<String>("URL", this.requestPattern.getUrlMatcher(), this.request.getUrl(), this.requestPattern.getUrlMatcher().getExpected());
        builder.add(urlSection);
        builder.add(SpacerLine.SPACER);
        boolean anyHeaderSections = false;
        Map<String, MultiValuePattern> headerPatterns = this.requestPattern.combineBasicAuthAndOtherHeaders();
        if (headerPatterns != null && !headerPatterns.isEmpty()) {
            anyHeaderSections = true;
            for (String key : headerPatterns.keySet()) {
                HttpHeader header = this.request.header(key);
                MultiValuePattern multiValuePattern = headerPatterns.get(header.key());
                String printedPatternValue = header.key() + ": " + multiValuePattern.getExpected();
                DiffLine<HttpHeader> section = new DiffLine<HttpHeader>("Header", multiValuePattern, header, printedPatternValue);
                builder.add(section);
            }
        }
        if (anyHeaderSections) {
            builder.add(SpacerLine.SPACER);
        }
        boolean anyCookieSections = false;
        if (this.requestPattern.getCookies() != null) {
            Map cookies = MoreObjects.firstNonNull(this.request.getCookies(), Collections.emptyMap());
            for (Map.Entry entry : this.requestPattern.getCookies().entrySet()) {
                String key = (String)entry.getKey();
                StringValuePattern pattern = (StringValuePattern)entry.getValue();
                Cookie cookie = MoreObjects.firstNonNull(cookies.get(key), Cookie.absent());
                DiffLine<String> section = new DiffLine<String>("Cookie", pattern, cookie.isPresent() ? "Cookie: " + key + "=" + cookie.getValue() : "", "Cookie: " + key + "=" + (String)pattern.getValue());
                builder.add(section);
                anyCookieSections = true;
            }
        }
        if (anyCookieSections) {
            builder.add(SpacerLine.SPACER);
        }
        if ((bodyPatterns = this.requestPattern.getBodyPatterns()) != null && !bodyPatterns.isEmpty()) {
            for (ContentPattern contentPattern : bodyPatterns) {
                String body = this.formatIfJsonOrXml(contentPattern);
                if (StringValuePattern.class.isAssignableFrom(contentPattern.getClass())) {
                    StringValuePattern stringValuePattern = (StringValuePattern)contentPattern;
                    builder.add(new DiffLine<String>("Body", stringValuePattern, body, contentPattern.getExpected()));
                    continue;
                }
                BinaryEqualToPattern nonStringPattern = (BinaryEqualToPattern)contentPattern;
                builder.add(new DiffLine<byte[]>("Body", nonStringPattern, body.getBytes(), contentPattern.getExpected()));
            }
        }
        return builder.build();
    }

    public String getStubMappingName() {
        return this.stubMappingName;
    }

    private String formatIfJsonOrXml(ContentPattern<?> pattern) {
        try {
            return pattern.getClass().equals(EqualToJsonPattern.class) ? Json.prettyPrint(this.request.getBodyAsString()) : (pattern.getClass().equals(EqualToXmlPattern.class) ? Xml.prettyPrint(this.request.getBodyAsString()) : (pattern.getClass().equals(BinaryEqualToPattern.class) ? BaseEncoding.base64().encode(this.request.getBody()) : this.request.getBodyAsString()));
        }
        catch (Exception e) {
            return this.request.getBodyAsString();
        }
    }

    public boolean hasCustomMatcher() {
        return this.requestPattern.hasCustomMatcher();
    }
}

