/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.AdminTasks;
import com.github.tomakehurst.wiremock.admin.EditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.FindNearMissesForRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.FindNearMissesForRequestTask;
import com.github.tomakehurst.wiremock.admin.FindNearMissesForUnmatchedTask;
import com.github.tomakehurst.wiremock.admin.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.FindUnmatchedRequestsTask;
import com.github.tomakehurst.wiremock.admin.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.RemoveStubMappingTask;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.ResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.ResetTask;
import com.github.tomakehurst.wiremock.admin.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.RootTask;
import com.github.tomakehurst.wiremock.admin.SaveMappingsTask;
import com.github.tomakehurst.wiremock.admin.ShutdownServerTask;
import com.github.tomakehurst.wiremock.admin.StubMappingTask;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.common.AdminException;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.base.Preconditions;
import wiremock.org.apache.http.client.methods.CloseableHttpResponse;
import wiremock.org.apache.http.client.methods.HttpGet;
import wiremock.org.apache.http.client.methods.HttpPost;
import wiremock.org.apache.http.client.methods.HttpRequestBase;
import wiremock.org.apache.http.entity.StringEntity;
import wiremock.org.apache.http.impl.client.CloseableHttpClient;

public class HttpAdminClient
implements Admin {
    private static final String ADMIN_URL_PREFIX = "%s://%s:%d%s/__admin";
    private final String scheme;
    private final String host;
    private final int port;
    private final String urlPathPrefix;
    private final CloseableHttpClient httpClient;

    public HttpAdminClient(String scheme, String host, int port) {
        this(scheme, host, port, "");
    }

    public HttpAdminClient(String host, int port, String urlPathPrefix) {
        this("http", host, port, urlPathPrefix);
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.urlPathPrefix = urlPathPrefix;
        this.httpClient = HttpClientFactory.createClient();
    }

    public HttpAdminClient(String host, int port) {
        this(host, port, "");
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        if (stubMapping.getRequest().hasCustomMatcher()) {
            throw new AdminException("Custom matchers can't be used when administering a remote WireMock server. Use WireMockRule.stubFor() or WireMockServer.stubFor() to administer the local instance.");
        }
        this.postJsonAssertOkAndReturnBody(this.urlFor(StubMappingTask.class), Json.write(stubMapping), 201);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(EditStubMappingTask.class), Json.write(stubMapping), 204);
    }

    @Override
    public void removeStubMapping(StubMapping stubbMapping) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(RemoveStubMappingTask.class), Json.write(stubbMapping), 200);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(RootTask.class), 200);
        return Json.read(body, ListStubMappingsResult.class);
    }

    @Override
    public void saveMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(SaveMappingsTask.class), null, 200);
    }

    @Override
    public void resetMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetTask.class), null, 200);
    }

    @Override
    public void resetRequests() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetRequestsTask.class), null, 200);
    }

    @Override
    public void resetScenarios() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetScenariosTask.class), null, 200);
    }

    @Override
    public void resetToDefaultMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetToDefaultMappingsTask.class), null, 200);
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(GetRequestCountTask.class), Json.write(requestPattern), 200);
        return VerificationResult.from(body);
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindRequestsTask.class), Json.write(requestPattern), 200);
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(FindUnmatchedRequestsTask.class), 200);
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForUnmatchedTask.class), 200);
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForRequestTask.class), Json.write(loggedRequest), 200);
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindNearMissesForRequestPatternTask.class), Json.write(requestPattern), 200);
        return Json.read(body, FindNearMissesResult.class);
    }

    @Override
    public void updateGlobalSettings(GlobalSettings settings) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(GlobalSettingsUpdateTask.class), Json.write(settings), 200);
    }

    @Override
    public void shutdownServer() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ShutdownServerTask.class), null, 200);
    }

    public int port() {
        return this.port;
    }

    private String postJsonAssertOkAndReturnBody(String url, String json, int expectedStatus) {
        HttpPost post = new HttpPost(url);
        if (json != null) {
            post.setEntity(HttpAdminClient.jsonStringEntity(json));
        }
        return this.safelyExecuteRequest(url, expectedStatus, post);
    }

    private static StringEntity jsonStringEntity(String json) {
        return new StringEntity(json, Charsets.UTF_8.name());
    }

    protected String getJsonAssertOkAndReturnBody(String url, int expectedStatus) {
        HttpGet get = new HttpGet(url);
        return this.safelyExecuteRequest(url, expectedStatus, get);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String safelyExecuteRequest(String url, int expectedStatus, HttpRequestBase request) {
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != expectedStatus) {
                throw new VerificationException("Expected status " + expectedStatus + " for " + url + " but was " + statusCode);
            }
            String string = HttpClientUtils.getEntityAsStringAndCloseStream(response);
            return string;
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private String urlFor(Class<? extends AdminTask> taskClass) {
        RequestSpec requestSpec = AdminTasks.requestSpecForTask(taskClass);
        Preconditions.checkNotNull(requestSpec, "No admin task URL is registered for " + taskClass.getSimpleName());
        return String.format(ADMIN_URL_PREFIX + requestSpec.path(), this.scheme, this.host, this.port, this.urlPathPrefix);
    }
}

