/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.com.jayway.jsonpath.Criteria;
import wiremock.com.jayway.jsonpath.InvalidPathException;
import wiremock.com.jayway.jsonpath.Predicate;
import wiremock.com.jayway.jsonpath.internal.Utils;

public abstract class Filter
implements Predicate {
    private static final Logger logger = LoggerFactory.getLogger(Filter.class);
    private static final Pattern OPERATOR_SPLIT = Pattern.compile("((?<=&&|\\|\\|)|(?=&&|\\|\\|))");
    private static final String AND = "&&";
    private static final String OR = "||";

    public static Filter filter(Predicate predicate) {
        return new SingleFilter(predicate);
    }

    public static Filter filter(Collection<Predicate> predicates) {
        return new AndFilter(predicates);
    }

    @Override
    public abstract boolean apply(Predicate.PredicateContext var1);

    public Filter or(Predicate other) {
        return new OrFilter(this, other);
    }

    public Filter and(Predicate other) {
        return new AndFilter(this, other);
    }

    public static Filter parse(String filter) {
        if (!(filter = filter.trim()).startsWith("[") || !filter.endsWith("]")) {
            throw new InvalidPathException("Filter must start with '[' and end with ']'. " + filter);
        }
        if (!(filter = filter.substring(1, filter.length() - 1).trim()).startsWith("?")) {
            throw new InvalidPathException("Filter must start with '[?' and end with ']'. " + filter);
        }
        if (!(filter = filter.substring(1).trim()).startsWith("(") || !filter.endsWith(")")) {
            throw new InvalidPathException("Filter must start with '[?(' and end with ')]'. " + filter);
        }
        filter = filter.substring(1, filter.length() - 1).trim();
        String[] split = OPERATOR_SPLIT.split(filter);
        Stack<String> operators = new Stack<String>();
        Stack<Criteria> criteria = new Stack<Criteria>();
        for (String exp : split) {
            if (AND.equals(exp = exp.trim()) || OR.equals(exp)) {
                operators.push(exp);
                continue;
            }
            criteria.push(Criteria.parse(Filter.cleanCriteria(exp)));
        }
        Filter root = new SingleFilter((Predicate)criteria.pop());
        while (!operators.isEmpty()) {
            String operator = (String)operators.pop();
            if (AND.equals(operator)) {
                root = root.and((Predicate)criteria.pop());
                continue;
            }
            if (criteria.isEmpty()) {
                throw new InvalidPathException("Invalid operators " + filter);
            }
            root = root.or((Predicate)criteria.pop());
        }
        if (!operators.isEmpty() || !criteria.isEmpty()) {
            throw new InvalidPathException("Invalid operators " + filter);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parsed filter: " + ((Object)root).toString());
        }
        return root;
    }

    private static String cleanCriteria(String filter) {
        int begin = 0;
        int end = filter.length() - 1;
        char c = filter.charAt(begin);
        while (c == '[' || c == '?' || c == '(' || c == ' ') {
            c = filter.charAt(++begin);
        }
        c = filter.charAt(end);
        while (c == ')' || c == ' ') {
            c = filter.charAt(--end);
        }
        return filter.substring(begin, end + 1);
    }

    private static final class OrFilter
    extends Filter {
        private final Predicate left;
        private final Predicate right;

        private OrFilter(Predicate left, Predicate right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Filter and(Predicate other) {
            return new OrFilter(this.left, new AndFilter(this.right, other));
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            boolean a = this.left.apply(ctx);
            return a || this.right.apply(ctx);
        }

        public String toString() {
            return "(" + this.left.toString() + " || " + this.right.toString() + ")";
        }
    }

    private static final class AndFilter
    extends Filter {
        private final Collection<Predicate> predicates;

        private AndFilter(Collection<Predicate> predicates) {
            this.predicates = predicates;
        }

        private AndFilter(Predicate left, Predicate right) {
            this(Arrays.asList(left, right));
        }

        @Override
        public Filter and(Predicate other) {
            ArrayList<Predicate> newPredicates = new ArrayList<Predicate>(this.predicates);
            newPredicates.add(other);
            return new AndFilter(newPredicates);
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            for (Predicate predicate : this.predicates) {
                if (predicate.apply(ctx)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "(" + Utils.join(" && ", this.predicates) + ")";
        }
    }

    private static final class SingleFilter
    extends Filter {
        private final Predicate predicate;

        private SingleFilter(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            return this.predicate.apply(ctx);
        }

        public String toString() {
            return this.predicate.toString();
        }
    }
}

