/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.base.Charsets;
import wiremock.org.apache.commons.codec.binary.Base64;

public class BasicCredentials {
    public final String username;
    public final String password;

    @JsonCreator
    public BasicCredentials(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password) {
        this.username = username;
        this.password = password;
    }

    public boolean present() {
        return this.username != null && this.password != null;
    }

    public MultiValuePattern asAuthorizationMultiValuePattern() {
        return MultiValuePattern.of(WireMock.equalTo(this.asAuthorizationHeaderValue()));
    }

    public String asAuthorizationHeaderValue() {
        byte[] usernameAndPassword = (this.username + ":" + this.password).getBytes();
        return "Basic " + new String(Base64.encodeBase64(usernameAndPassword), Charsets.UTF_8);
    }
}

