/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.EditStubMappingTask;
import com.github.tomakehurst.wiremock.admin.FindNearMissesForRequestPatternTask;
import com.github.tomakehurst.wiremock.admin.FindNearMissesForRequestTask;
import com.github.tomakehurst.wiremock.admin.FindNearMissesForUnmatchedTask;
import com.github.tomakehurst.wiremock.admin.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.FindUnmatchedRequestsTask;
import com.github.tomakehurst.wiremock.admin.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.NotFoundAdminTask;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.ResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.ResetTask;
import com.github.tomakehurst.wiremock.admin.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.RootRedirectTask;
import com.github.tomakehurst.wiremock.admin.RootTask;
import com.github.tomakehurst.wiremock.admin.SaveMappingsTask;
import com.github.tomakehurst.wiremock.admin.ShutdownServerTask;
import com.github.tomakehurst.wiremock.admin.StubMappingTask;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import wiremock.com.google.common.collect.BiMap;
import wiremock.com.google.common.collect.ImmutableBiMap;

public class AdminTasks {
    private static final BiMap<RequestSpec, Class<? extends AdminTask>> TASKS = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().put(RequestSpec.requestSpec(RequestMethod.GET, "/"), RootTask.class)).put(RequestSpec.requestSpec(RequestMethod.GET, ""), RootRedirectTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/reset"), ResetTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/mappings/new"), StubMappingTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/mappings/edit"), EditStubMappingTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/scenarios/reset"), ResetScenariosTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/mappings/save"), SaveMappingsTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/mappings/reset"), ResetToDefaultMappingsTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/requests/reset"), ResetRequestsTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/requests/count"), GetRequestCountTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/requests/find"), FindRequestsTask.class)).put(RequestSpec.requestSpec(RequestMethod.GET, "/requests/unmatched"), FindUnmatchedRequestsTask.class)).put(RequestSpec.requestSpec(RequestMethod.GET, "/requests/unmatched/near-misses"), FindNearMissesForUnmatchedTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/near-misses/request"), FindNearMissesForRequestTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/near-misses/request-pattern"), FindNearMissesForRequestPatternTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/settings"), GlobalSettingsUpdateTask.class)).put(RequestSpec.requestSpec(RequestMethod.POST, "/shutdown"), ShutdownServerTask.class)).build();

    public static AdminTask taskFor(RequestMethod method, String path) {
        Class taskClass = (Class)TASKS.get(RequestSpec.requestSpec(method, path));
        if (taskClass == null) {
            return new NotFoundAdminTask();
        }
        try {
            return (AdminTask)taskClass.newInstance();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, AdminTask.class);
        }
    }

    public static RequestSpec requestSpecForTask(Class<? extends AdminTask> taskClass) {
        return (RequestSpec)TASKS.inverse().get(taskClass);
    }
}

