/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit.examples;

import java.io.IOException;
import java.io.Reader;
import junit.framework.Assert;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import wiremock.org.custommonkey.xmlunit.XMLUnit;
import wiremock.org.custommonkey.xmlunit.XpathEngine;
import wiremock.org.custommonkey.xmlunit.exceptions.XpathException;

public class XPathRegexAssert {
    private XPathRegexAssert() {
    }

    public static void assertXPathMatches(String message, String regex, String xpath, Document doc) throws XpathException {
        XpathEngine engine = XMLUnit.newXpathEngine();
        String value = engine.evaluate(xpath, doc);
        Assert.assertTrue((String)message, (boolean)value.matches(regex));
    }

    public static void assertXPathMatches(String message, String regex, String xpath, String xml) throws XpathException, SAXException, IOException {
        Document doc = XMLUnit.buildControlDocument(xml);
        XPathRegexAssert.assertXPathMatches(message, regex, xpath, doc);
    }

    public static void assertXPathMatches(String message, String regex, String xpath, Reader reader) throws XpathException, SAXException, IOException {
        Document doc = XMLUnit.buildControlDocument(new InputSource(reader));
        XPathRegexAssert.assertXPathMatches(message, regex, xpath, doc);
    }

    public static void assertXPathMatches(String regex, String xpath, Document doc) throws XpathException {
        XPathRegexAssert.assertXPathMatches("expected value to match " + regex, regex, xpath, doc);
    }

    public static void assertXPathMatches(String regex, String xpath, String xml) throws XpathException, SAXException, IOException {
        XPathRegexAssert.assertXPathMatches("expected value to match " + regex, regex, xpath, xml);
    }

    public static void assertXPathMatches(String regex, String xpath, Reader reader) throws XpathException, SAXException, IOException {
        XPathRegexAssert.assertXPathMatches("expected value to match " + regex, regex, xpath, reader);
    }
}

