/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.custommonkey.xmlunit.examples;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wiremock.org.custommonkey.xmlunit.ElementNameAndTextQualifier;
import wiremock.org.custommonkey.xmlunit.ElementNameQualifier;
import wiremock.org.custommonkey.xmlunit.ElementQualifier;

public class MultiLevelElementNameAndTextQualifier
implements ElementQualifier {
    private final int levels;
    private final boolean ignoreEmptyTexts;
    private static final ElementNameQualifier NAME_QUALIFIER = new ElementNameQualifier();
    private static final ElementNameAndTextQualifier NAME_AND_TEXT_QUALIFIER = new ElementNameAndTextQualifier();

    public MultiLevelElementNameAndTextQualifier(int levels) {
        this(levels, false);
    }

    public MultiLevelElementNameAndTextQualifier(int levels, boolean ignoreEmptyTexts) {
        if (levels < 1) {
            throw new IllegalArgumentException("levels must be equal or greater than one");
        }
        this.levels = levels;
        this.ignoreEmptyTexts = ignoreEmptyTexts;
    }

    public boolean qualifyForComparison(Element control, Element test) {
        boolean stillSimilar = true;
        Element currentControl = control;
        Element currentTest = test;
        for (int currentLevel = 0; stillSimilar && currentLevel <= this.levels - 2; ++currentLevel) {
            stillSimilar = NAME_QUALIFIER.qualifyForComparison(currentControl, currentTest);
            if (!stillSimilar) continue;
            if (currentControl.hasChildNodes() && currentTest.hasChildNodes()) {
                Node n1 = this.getFirstEligibleChild(currentControl);
                Node n2 = this.getFirstEligibleChild(currentTest);
                if (n1.getNodeType() == 1 && n2.getNodeType() == 1) {
                    currentControl = (Element)n1;
                    currentTest = (Element)n2;
                    continue;
                }
                stillSimilar = false;
                continue;
            }
            stillSimilar = false;
        }
        if (stillSimilar) {
            stillSimilar = NAME_AND_TEXT_QUALIFIER.qualifyForComparison(currentControl, currentTest);
        }
        return stillSimilar;
    }

    private Node getFirstEligibleChild(Node parent) {
        Node n1 = parent.getFirstChild();
        if (this.ignoreEmptyTexts) {
            Node n2;
            while (n1.getNodeType() == 3 && n1.getNodeValue().trim().length() == 0 && (n2 = n1.getNextSibling()) != null) {
                n1 = n2;
            }
        }
        return n1;
    }
}

