/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.JsonStubMappingCreator;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.Iterables;

public class JsonFileMappingsLoader
implements MappingsLoader {
    private final FileSource mappingsFileSource;

    public JsonFileMappingsLoader(FileSource mappingsFileSource) {
        this.mappingsFileSource = mappingsFileSource;
    }

    @Override
    public void loadMappingsInto(StubMappings stubMappings) {
        JsonStubMappingCreator jsonStubMappingCreator = new JsonStubMappingCreator(stubMappings);
        Iterable<TextFile> mappingFiles = Iterables.filter(this.mappingsFileSource.listFilesRecursively(), this.byFileExtension("json"));
        for (TextFile mappingFile : mappingFiles) {
            jsonStubMappingCreator.addMappingFrom(mappingFile.readContentsAsString());
        }
    }

    private Predicate<TextFile> byFileExtension(final String extension) {
        return new Predicate<TextFile>(){

            @Override
            public boolean apply(TextFile input) {
                return input.name().endsWith("." + extension);
            }
        };
    }
}

