/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.AdminTasks;
import com.github.tomakehurst.wiremock.admin.FindRequestsTask;
import com.github.tomakehurst.wiremock.admin.GetRequestCountTask;
import com.github.tomakehurst.wiremock.admin.GlobalSettingsUpdateTask;
import com.github.tomakehurst.wiremock.admin.NewStubMappingTask;
import com.github.tomakehurst.wiremock.admin.RequestSpec;
import com.github.tomakehurst.wiremock.admin.ResetRequestsTask;
import com.github.tomakehurst.wiremock.admin.ResetScenariosTask;
import com.github.tomakehurst.wiremock.admin.ResetTask;
import com.github.tomakehurst.wiremock.admin.ResetToDefaultMappingsTask;
import com.github.tomakehurst.wiremock.admin.RootTask;
import com.github.tomakehurst.wiremock.admin.SaveMappingsTask;
import com.github.tomakehurst.wiremock.admin.ShutdownServerTask;
import com.github.tomakehurst.wiremock.admin.SocketDelayTask;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.common.AdminException;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.RequestDelaySpec;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import wiremock.org.apache.http.HttpResponse;
import wiremock.org.apache.http.client.HttpClient;
import wiremock.org.apache.http.client.methods.HttpGet;
import wiremock.org.apache.http.client.methods.HttpPost;
import wiremock.org.apache.http.entity.ContentType;
import wiremock.org.apache.http.entity.StringEntity;

public class HttpAdminClient
implements Admin {
    private static final String ADMIN_URL_PREFIX = "%s://%s:%d%s/__admin";
    private final String scheme;
    private final String host;
    private final int port;
    private final String urlPathPrefix;
    private final HttpClient httpClient;

    public HttpAdminClient(String scheme, String host, int port) {
        this(scheme, host, port, "");
    }

    public HttpAdminClient(String host, int port, String urlPathPrefix) {
        this("http", host, port, urlPathPrefix);
    }

    public HttpAdminClient(String scheme, String host, int port, String urlPathPrefix) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.urlPathPrefix = urlPathPrefix;
        this.httpClient = HttpClientFactory.createClient();
    }

    public HttpAdminClient(String host, int port) {
        this(host, port, "");
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        if (stubMapping.getRequest().hasCustomMatcher()) {
            throw new AdminException("Custom matchers can't be used when administering a remote WireMock server. Use WireMockRule.stubFor() or WireMockServer.stubFor() to administer the local instance.");
        }
        this.postJsonAssertOkAndReturnBody(this.urlFor(NewStubMappingTask.class), Json.write(stubMapping), 201);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        String body = this.getJsonAssertOkAndReturnBody(this.urlFor(RootTask.class), 200);
        return Json.read(body, ListStubMappingsResult.class);
    }

    @Override
    public void saveMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(SaveMappingsTask.class), null, 200);
    }

    @Override
    public void resetMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetTask.class), null, 200);
    }

    @Override
    public void resetRequests() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetRequestsTask.class), null, 200);
    }

    @Override
    public void resetScenarios() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetScenariosTask.class), null, 200);
    }

    @Override
    public void resetToDefaultMappings() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ResetToDefaultMappingsTask.class), null, 200);
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(GetRequestCountTask.class), Json.write(requestPattern), 200);
        return VerificationResult.from(body);
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        String body = this.postJsonAssertOkAndReturnBody(this.urlFor(FindRequestsTask.class), Json.write(requestPattern), 200);
        return Json.read(body, FindRequestsResult.class);
    }

    @Override
    public void updateGlobalSettings(GlobalSettings settings) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(GlobalSettingsUpdateTask.class), Json.write(settings), 200);
    }

    @Override
    public void addSocketAcceptDelay(RequestDelaySpec spec) {
        this.postJsonAssertOkAndReturnBody(this.urlFor(SocketDelayTask.class), Json.write(spec), 200);
    }

    @Override
    public void shutdownServer() {
        this.postJsonAssertOkAndReturnBody(this.urlFor(ShutdownServerTask.class), null, 200);
    }

    public int port() {
        return this.port;
    }

    private String postJsonAssertOkAndReturnBody(String url, String json, int expectedStatus) {
        HttpPost post = new HttpPost(url);
        try {
            HttpResponse response;
            int statusCode;
            if (json != null) {
                post.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
            }
            if ((statusCode = (response = this.httpClient.execute(post)).getStatusLine().getStatusCode()) != expectedStatus) {
                throw new VerificationException("Expected status " + expectedStatus + " for " + url + " but was " + statusCode);
            }
            return HttpClientUtils.getEntityAsStringAndCloseStream(response);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    protected String getJsonAssertOkAndReturnBody(String url, int expectedStatus) {
        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = this.httpClient.execute(get);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != expectedStatus) {
                throw new VerificationException("Expected status " + expectedStatus + " for " + url + " but was " + statusCode);
            }
            return HttpClientUtils.getEntityAsStringAndCloseStream(response);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private String urlFor(Class<? extends AdminTask> taskClass) {
        RequestSpec requestSpec = AdminTasks.requestSpecForTask(taskClass);
        return String.format(ADMIN_URL_PREFIX + requestSpec.path(), this.scheme, this.host, this.port, this.urlPathPrefix);
    }
}

