/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.collect.Iterables;
import wiremock.com.google.common.collect.Lists;
import wiremock.com.google.common.io.Files;

public abstract class AbstractFileSource
implements FileSource {
    protected final File rootDirectory;

    public AbstractFileSource(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    protected abstract boolean readOnly();

    @Override
    public BinaryFile getBinaryFileNamed(String name) {
        return new BinaryFile(new File(this.rootDirectory, name).toURI());
    }

    @Override
    public void createIfNecessary() {
        this.assertWritable();
        if (this.rootDirectory.exists() && this.rootDirectory.isFile()) {
            throw new IllegalStateException(this.rootDirectory + " already exists and is a file");
        }
        if (!this.rootDirectory.exists()) {
            this.rootDirectory.mkdirs();
        }
    }

    @Override
    public String getPath() {
        return this.rootDirectory.getPath();
    }

    @Override
    public List<TextFile> listFilesRecursively() {
        this.assertExistsAndIsDirectory();
        ArrayList<File> fileList = Lists.newArrayList();
        this.recursivelyAddFilesToList(this.rootDirectory, fileList);
        return this.toTextFileList(fileList);
    }

    private void recursivelyAddFilesToList(File root, List<File> fileList) {
        File[] files;
        for (File file : files = root.listFiles()) {
            if (file.isDirectory()) {
                this.recursivelyAddFilesToList(file, fileList);
                continue;
            }
            fileList.add(file);
        }
    }

    private List<TextFile> toTextFileList(List<File> fileList) {
        return Lists.newArrayList(Iterables.transform(fileList, new Function<File, TextFile>(){

            @Override
            public TextFile apply(File input) {
                return new TextFile(input.toURI());
            }
        }));
    }

    @Override
    public void writeTextFile(String name, String contents) {
        this.writeTextFileAndTranslateExceptions(contents, this.writableFileFor(name));
    }

    @Override
    public void writeBinaryFile(String name, byte[] contents) {
        this.writeBinaryFileAndTranslateExceptions(contents, this.writableFileFor(name));
    }

    @Override
    public boolean exists() {
        return this.rootDirectory.exists();
    }

    private File writableFileFor(String name) {
        this.assertExistsAndIsDirectory();
        this.assertWritable();
        return new File(this.rootDirectory, name);
    }

    private void assertExistsAndIsDirectory() {
        if (this.rootDirectory.exists() && !this.rootDirectory.isDirectory()) {
            throw new RuntimeException(this.rootDirectory + " is not a directory");
        }
        if (!this.rootDirectory.exists()) {
            throw new RuntimeException(this.rootDirectory + " does not exist");
        }
    }

    private void assertWritable() {
        if (this.readOnly()) {
            throw new UnsupportedOperationException("Can't write to read only file sources");
        }
    }

    private void writeTextFileAndTranslateExceptions(String contents, File toFile) {
        try {
            Files.write(contents, toFile, Charsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void writeBinaryFileAndTranslateExceptions(byte[] contents, File toFile) {
        try {
            Files.write(contents, toFile);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private FileFilter filesOnly() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        };
    }
}

