/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.thread;

import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;
import wiremock.org.eclipse.jetty.util.Loader;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;
import wiremock.org.eclipse.jetty.util.thread.strategy.ExecuteProduceConsume;

public interface ExecutionStrategy {
    public void dispatch();

    public void execute();

    public static class Factory {
        private static final Logger LOG = Log.getLogger(Factory.class);

        public static ExecutionStrategy instanceFor(Producer producer, Executor executor) {
            String strategy = System.getProperty(producer.getClass().getName() + ".ExecutionStrategy");
            if (strategy != null) {
                try {
                    Class c = Loader.loadClass(producer.getClass(), strategy);
                    Constructor m = c.getConstructor(Producer.class, Executor.class);
                    LOG.info("Use {} for {}", c.getSimpleName(), producer.getClass().getName());
                    return (ExecutionStrategy)m.newInstance(producer, executor);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
            return new ExecuteProduceConsume(producer, executor);
        }
    }

    public static interface Producer {
        public Runnable produce();
    }
}

