/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class ListOrStringDeserialiser<T>
extends JsonDeserializer<ListOrSingle<T>> {
    public ListOrSingle<T> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (rootNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)rootNode;
            ArrayList items = Lists.newArrayList();
            Iterator i = arrayNode.elements();
            while (i.hasNext()) {
                JsonNode node = (JsonNode)i.next();
                Object value = ListOrStringDeserialiser.getValue(node);
                items.add(value);
            }
            return new ListOrSingle(items);
        }
        return new ListOrSingle<Object>(ListOrStringDeserialiser.getValue(rootNode));
    }

    private static Object getValue(JsonNode node) {
        return node.isTextual() ? node.textValue() : (node.isNumber() ? node.numberValue() : (node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : node.textValue()));
    }
}

