/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RenderableDate
extends Date {
    private static final long DIVIDE_MILLISECONDS_TO_SECONDS = 1000L;
    private final String format;
    private final String timezoneName;

    public RenderableDate(Date date, String format, String timezone) {
        super(date.getTime());
        this.format = format;
        this.timezoneName = timezone;
    }

    @Override
    public String toString() {
        if (this.format != null) {
            if (this.format.equals("epoch")) {
                return String.valueOf(this.getTime());
            }
            if (this.format.equals("unix")) {
                return String.valueOf(this.getTime() / 1000L);
            }
            return this.formatCustom();
        }
        return this.timezoneName != null ? ISO8601Utils.format((Date)this, (boolean)false, (TimeZone)TimeZone.getTimeZone(this.timezoneName)) : ISO8601Utils.format((Date)this, (boolean)false);
    }

    private String formatCustom() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.format);
        if (this.timezoneName != null) {
            TimeZone zone = TimeZone.getTimeZone(this.timezoneName);
            dateFormat.setTimeZone(zone);
        }
        return dateFormat.format(this);
    }
}

