/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimeMatchResult;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimePattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;

public class AfterDateTimePattern
extends AbstractDateTimePattern {
    public AfterDateTimePattern(ZonedDateTime zonedDateTime) {
        super(zonedDateTime);
    }

    public AfterDateTimePattern(LocalDateTime localDateTime) {
        super(localDateTime);
    }

    public AfterDateTimePattern(String dateTimeSpec) {
        super(dateTimeSpec);
    }

    public AfterDateTimePattern(@JsonProperty(value="after") String dateTimeSpec, @JsonProperty(value="actualFormat") String actualDateFormat, @JsonProperty(value="truncateExpected") String truncateExpected, @JsonProperty(value="truncateActual") String truncateActual, @JsonProperty(value="expectedOffset") Integer expectedOffsetAmount, @JsonProperty(value="expectedOffsetUnit") DateTimeUnit expectedOffsetUnit) {
        super(dateTimeSpec, actualDateFormat, truncateExpected, truncateActual, expectedOffsetAmount, expectedOffsetUnit);
    }

    @Override
    protected MatchResult getMatchResult(ZonedDateTime zonedExpected, LocalDateTime localExpected, ZonedDateTime zonedActual, LocalDateTime localActual) {
        return new AbstractDateTimeMatchResult(zonedExpected, localExpected, zonedActual, localActual){

            @Override
            protected boolean matchZonedZoned() {
                return this.zonedActual.isAfter(this.zonedExpected);
            }

            @Override
            protected boolean matchLocalLocal() {
                return this.localActual.isAfter(this.localExpected);
            }

            @Override
            protected boolean matchLocalZoned() {
                return this.zonedActual.toLocalDateTime().isAfter(this.localExpected);
            }
        };
    }

    public String getAfter() {
        return this.getValue();
    }
}

