/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.helper.AssignHelper;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.NumberHelper;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateCacheKey;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class ResponseTemplateTransformer
extends ResponseDefinitionTransformer
implements StubLifecycleListener {
    public static final String NAME = "response-template";
    private final boolean global;
    private final Handlebars handlebars;
    private final Cache<TemplateCacheKey, HandlebarsOptimizedTemplate> cache;
    private final Long maxCacheEntries;

    public static Builder builder() {
        return new Builder();
    }

    public ResponseTemplateTransformer(boolean global) {
        this(global, Collections.emptyMap());
    }

    public ResponseTemplateTransformer(boolean global, String helperName, Helper helper) {
        this(global, (Map<String, Helper>)ImmutableMap.of((Object)helperName, (Object)helper));
    }

    public ResponseTemplateTransformer(boolean global, Map<String, Helper> helpers) {
        this(global, new Handlebars(), helpers, null);
    }

    public ResponseTemplateTransformer(boolean global, Handlebars handlebars, Map<String, Helper> helpers, Long maxCacheEntries) {
        this.global = global;
        this.handlebars = handlebars;
        for (StringHelpers stringHelpers : StringHelpers.values()) {
            if (stringHelpers.name().equals("now")) continue;
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (StringHelpers stringHelpers : NumberHelper.values()) {
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (StringHelpers stringHelpers : ConditionalHelpers.values()) {
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        this.handlebars.registerHelper("assign", (Helper)new AssignHelper());
        for (StringHelpers stringHelpers : WireMockHelpers.values()) {
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (Map.Entry entry : helpers.entrySet()) {
            this.handlebars.registerHelper((String)entry.getKey(), (Helper)entry.getValue());
        }
        this.maxCacheEntries = maxCacheEntries;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (maxCacheEntries != null) {
            cacheBuilder.maximumSize(maxCacheEntries.longValue());
        }
        this.cache = cacheBuilder.build();
    }

    @Override
    public boolean applyGlobally() {
        return this.global;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ResponseDefinition transform(Request request, final ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        ResponseDefinitionBuilder newResponseDefBuilder = ResponseDefinitionBuilder.like(responseDefinition);
        final ImmutableMap model = ImmutableMap.builder().put((Object)"parameters", MoreObjects.firstNonNull((Object)parameters, Collections.emptyMap())).put((Object)"request", (Object)RequestTemplateModel.from(request)).putAll(this.addExtraModelElements(request, responseDefinition, files, parameters)).build();
        if (responseDefinition.specifiesTextBodyContent()) {
            HandlebarsOptimizedTemplate bodyTemplate = this.getTemplate(TemplateCacheKey.forInlineBody(responseDefinition), responseDefinition.getBody());
            this.applyTemplatedResponseBody(newResponseDefBuilder, (ImmutableMap<String, Object>)model, bodyTemplate);
        } else if (responseDefinition.specifiesBodyFile()) {
            HandlebarsOptimizedTemplate filePathTemplate = new HandlebarsOptimizedTemplate(this.handlebars, responseDefinition.getBodyFileName());
            String compiledFilePath = this.uncheckedApplyTemplate(filePathTemplate, model);
            TextFile file = files.getTextFileNamed(compiledFilePath);
            boolean disableBodyFileTemplating = parameters.getBoolean("disableBodyFileTemplating", false);
            if (!disableBodyFileTemplating) {
                HandlebarsOptimizedTemplate bodyTemplate = this.getTemplate(TemplateCacheKey.forFileBody(responseDefinition, compiledFilePath), file.readContentsAsString());
                this.applyTemplatedResponseBody(newResponseDefBuilder, (ImmutableMap<String, Object>)model, bodyTemplate);
            }
        }
        if (responseDefinition.getHeaders() != null) {
            Iterable newResponseHeaders = Iterables.transform(responseDefinition.getHeaders().all(), (Function)new Function<HttpHeader, HttpHeader>(){

                public HttpHeader apply(HttpHeader header) {
                    ImmutableList.Builder valueListBuilder = ImmutableList.builder();
                    int index = 0;
                    for (String headerValue : header.values()) {
                        HandlebarsOptimizedTemplate template = ResponseTemplateTransformer.this.getTemplate(TemplateCacheKey.forHeader(responseDefinition, header.key(), index++), headerValue);
                        valueListBuilder.add((Object)ResponseTemplateTransformer.this.uncheckedApplyTemplate(template, model));
                    }
                    return new HttpHeader(header.key(), (Collection<String>)valueListBuilder.build());
                }
            });
            newResponseDefBuilder.withHeaders(new HttpHeaders(newResponseHeaders));
        }
        if (responseDefinition.getProxyBaseUrl() != null) {
            HandlebarsOptimizedTemplate proxyBaseUrlTemplate = this.getTemplate(TemplateCacheKey.forProxyUrl(responseDefinition), responseDefinition.getProxyBaseUrl());
            String newProxyBaseUrl = this.uncheckedApplyTemplate(proxyBaseUrlTemplate, model);
            newResponseDefBuilder.proxiedFrom(newProxyBaseUrl);
        }
        return newResponseDefBuilder.build();
    }

    protected Map<String, Object> addExtraModelElements(Request request, ResponseDefinition responseDefinition, FileSource files, Parameters parameters) {
        return Collections.emptyMap();
    }

    private void applyTemplatedResponseBody(ResponseDefinitionBuilder newResponseDefBuilder, ImmutableMap<String, Object> model, HandlebarsOptimizedTemplate bodyTemplate) {
        String newBody = this.uncheckedApplyTemplate(bodyTemplate, model);
        newResponseDefBuilder.withBody(newBody);
    }

    private String uncheckedApplyTemplate(HandlebarsOptimizedTemplate template, Object context) {
        try {
            return template.apply(context);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private HandlebarsOptimizedTemplate getTemplate(TemplateCacheKey key, final String content) {
        if (this.maxCacheEntries != null && this.maxCacheEntries < 1L) {
            return new HandlebarsOptimizedTemplate(this.handlebars, content);
        }
        try {
            return (HandlebarsOptimizedTemplate)this.cache.get((Object)key, (Callable)new Callable<HandlebarsOptimizedTemplate>(){

                @Override
                public HandlebarsOptimizedTemplate call() {
                    return new HandlebarsOptimizedTemplate(ResponseTemplateTransformer.this.handlebars, content);
                }
            });
        }
        catch (ExecutionException e) {
            return Exceptions.throwUnchecked(e, HandlebarsOptimizedTemplate.class);
        }
    }

    @Override
    public void stubCreated(StubMapping stub) {
    }

    @Override
    public void stubEdited(StubMapping oldStub, StubMapping newStub) {
    }

    @Override
    public void stubRemoved(StubMapping stub) {
        this.cache.invalidateAll();
    }

    @Override
    public void stubsReset() {
        this.cache.invalidateAll();
    }

    public long getCacheSize() {
        return this.cache.size();
    }

    public Long getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public static class Builder {
        private boolean global = true;
        private Handlebars handlebars = new Handlebars();
        private Map<String, Helper> helpers = new HashMap<String, Helper>();
        private Long maxCacheEntries = null;

        public Builder global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder handlebars(Handlebars handlebars) {
            this.handlebars = handlebars;
            return this;
        }

        public Builder helpers(Map<String, Helper> helpers) {
            this.helpers = helpers;
            return this;
        }

        public Builder helper(String name, Helper helper) {
            this.helpers.put(name, helper);
            return this;
        }

        public Builder maxCacheEntries(Long maxCacheEntries) {
            this.maxCacheEntries = maxCacheEntries;
            return this;
        }

        public ResponseTemplateTransformer build() {
            return new ResponseTemplateTransformer(this.global, this.handlebars, this.helpers, this.maxCacheEntries);
        }
    }
}

