/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.JsonException;
import java.io.IOException;
import java.util.Map;
import wiremock.com.fasterxml.jackson.annotation.JsonInclude;
import wiremock.com.fasterxml.jackson.core.JsonGenerator;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;
import wiremock.com.fasterxml.jackson.databind.DeserializationFeature;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.com.fasterxml.jackson.databind.ObjectWriter;

public final class Json {
    private static final InheritableThreadLocal<ObjectMapper> objectMapperHolder = new InheritableThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            objectMapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
            objectMapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
            objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
            return objectMapper;
        }
    };

    private Json() {
    }

    public static <T> T read(String json, Class<T> clazz) {
        try {
            ObjectMapper mapper = Json.getObjectMapper();
            return mapper.readValue(json, clazz);
        }
        catch (JsonProcessingException processingException) {
            throw JsonException.fromJackson(processingException);
        }
    }

    public static <T> T read(String json, TypeReference<T> typeRef) {
        try {
            ObjectMapper mapper = Json.getObjectMapper();
            return mapper.readValue(json, typeRef);
        }
        catch (JsonProcessingException processingException) {
            throw JsonException.fromJackson(processingException);
        }
    }

    public static <T> String write(T object) {
        return Json.write(object, PublicView.class);
    }

    public static <T> String writePrivate(T object) {
        return Json.write(object, PrivateView.class);
    }

    public static <T> String write(T object, Class<?> view) {
        try {
            ObjectMapper mapper = Json.getObjectMapper();
            ObjectWriter objectWriter = mapper.writerWithDefaultPrettyPrinter();
            if (view != null) {
                objectWriter = objectWriter.withView(view);
            }
            return objectWriter.writeValueAsString(object);
        }
        catch (IOException ioe) {
            return Exceptions.throwUnchecked(ioe, String.class);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return (ObjectMapper)objectMapperHolder.get();
    }

    public static byte[] toByteArray(Object object) {
        try {
            ObjectMapper mapper = Json.getObjectMapper();
            return mapper.writeValueAsBytes(object);
        }
        catch (IOException ioe) {
            return Exceptions.throwUnchecked(ioe, byte[].class);
        }
    }

    public static JsonNode node(String json) {
        return Json.read(json, JsonNode.class);
    }

    public static int maxDeepSize(JsonNode one, JsonNode two) {
        return Math.max(Json.deepSize(one), Json.deepSize(two));
    }

    public static int deepSize(JsonNode node) {
        if (node == null) {
            return 0;
        }
        int acc = 1;
        if (node.isContainerNode()) {
            for (JsonNode child : node) {
                ++acc;
                if (!child.isContainerNode()) continue;
                acc += Json.deepSize(child);
            }
        }
        return acc;
    }

    public static String prettyPrint(String json) {
        ObjectMapper mapper = Json.getObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(mapper.readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> targetClass) {
        ObjectMapper mapper = Json.getObjectMapper();
        return mapper.convertValue(map, targetClass);
    }

    public static <T> Map<String, Object> objectToMap(T theObject) {
        ObjectMapper mapper = Json.getObjectMapper();
        return mapper.convertValue(theObject, new TypeReference<Map<String, Object>>(){});
    }

    public static class PublicView {
    }

    public static class PrivateView {
    }
}

