/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.DateTimeOffset;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RenderableDate;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Date;
import wiremock.com.github.jknack.handlebars.Options;

public class HandlebarsCurrentDateHelper
extends HandlebarsHelper<Date> {
    @Override
    public Object apply(Date context, Options options) throws IOException {
        ZoneId zoneId;
        Date date;
        String format = (String)options.hash("format", null);
        String offset = (String)options.hash("offset", null);
        String timezone = (String)options.hash("timezone", null);
        if (context instanceof RenderableDate) {
            date = context;
            RenderableDate renderableDate = (RenderableDate)context;
            zoneId = renderableDate.getTimezone();
        } else {
            date = context != null ? context : new Date();
            ZoneId zoneId2 = zoneId = timezone != null ? ZoneId.of(timezone) : null;
        }
        if (offset != null) {
            date = DateTimeOffset.fromString(offset).shift(date);
        }
        return new RenderableDate(date, format, zoneId);
    }
}

